#!/bin/sh
# InstallShield (R)
# (c)2005, Macrovision Corporation
# (c)1996-2003, InstallShield Software Corporation
# (c)1990-1996, InstallShield Corporation
# All Rights Reserved.

#FileService
getFileOwner()
{
	if [ \( -f "$2" -o -d "$2"  \) ] ; then
		ls -ld "$2" | awk '{ print $3; }'
	else
		echo ERROR >&1
		echo "getFileOwner script function failed. File argument is either empty or the file does not exist." 1>&2
	fi
}

#FileService
setFileOwner()
{
	if [ -f "$2" ] ; then
		chown "$3" "$2"
		echo OK >&1
	elif [ -d  "$2" ] ; then
		chown -R "$3" "$2"
		echo OK >&1
	else
		echo ERROR >&1
		echo "setFileOwner script function failed. File argument is either empty or the file does not exist." 1>&2
	fi
}

#FileService
getFileOwnerGroup()
{
	if [ \( -f "$2" -o -d "$2" \) ] ; then
		ls -ld "$2" | awk '{ print $4 }'
	else
		echo ERROR >&1
		echo "getFileOwnerGroup script function failed. File argument is either empty or the file does not exist." 1>&2
	fi
}

#FileService
setFileOwnerGroup()
{
	if [ -f "$2" ] ; then
		chgrp "$3" "$2"
		echo OK >&1
	elif [ -d  "$2" ] ; then
		chgrp -R "$3" "$2"
		echo OK >&1
	else
		echo ERROR >&1
		echo "setFileOwnerGroup script function failed. File argument is either empty or the file does not exist." 1>&2
    fi
}

#FileService
getFileAttributes()
{
	if [ \( -f "$2" -o  -d "$2" \) ] ; then
		var=`ls -ld "$2" |\
		 awk '{ u=0; g=0; o=0;\
						ur=substr($1,2,1); uw=substr($1,3,1); ux=substr($1,4,1);\
						gr=substr($1,5,1); gw=substr($1,6,1); gx=substr($1,7,1);\
						wr=substr($1,8,1); ow=substr($1,9,1); ox=substr($1,10,1);\
						if(ur=="r") u=u+256; if(uw=="w") u=u+128; if(ux=="x") u=u+64;\
						if(gr=="r") g=g+32; if(gw=="w") g=g+16; if(gx=="x") g=g+8;\
						if(wr=="r") o=o+4; if(ow=="w") o=o+2; if(ox=="x") o=o+1;\
						print u+g+o;\
					}'`
		echo $var
		else
			echo ERROR >&1
			echo "getFileAttributes script function failed. File argument is either empty or the file does not exist." 1>&2
		fi
}

#FileService
setFileAttributes()
{
	if [ \( -f "$2" -o -d "$2" \) ] ; then
		chmod "$3" "$2"
		echo OK >&1
	else
		echo ERROR >&1
		echo "setFileAttributes script function failed. File argument is either empty or the file does not exist." 1>&2
	fi
}

#FileService
setFileTimes()
{
	if [ \( -f "$2" -o -d "$2" \) ] ; then
		touch -a -t "$4" "$2"
		touch -m -t "$5" "$2"
		echo OK >&1
	else
		echo ERROR >&1
		echo "setFileTimes script function failed. File argument is either empty or the file does not exist." 1>&2
    fi
}

#FileService
setFileModified()
{
	if [ \( -f "$2" -o -d "$2" \) ] ; then
		touch -m -t "$3" "$2"
		echo OK >&1
	else
		echo ERROR >&1
		echo "setFileModified script function failed. File argument is either empty or the file does not exist." 1>&2
	fi
}

#FileService
getSystemUMask()
{
	umask
}

#FileService
setSystemUmask()
{
	umask "$2"
	echo OK >&1
}

#FileService
getPartitionNames()
{
	df -P 2>/dev/null 1>&2
	# If POSIX complaint
	if [ $? -eq 0 ] ; then 
		df  -P | awk ' NR > 1 { s=sprintf("%s,%s",$6,s ); } END { print s }' 2>/dev/null
	# Is Solaris xpg4 available
	elif  [ -x /usr/xpg4/bin/df ] ; then 
		/usr/xpg4/bin/df -P  | awk ' NR > 1 { s=sprintf("%s,%s",$6,s); } END { print s }' 2>/dev/null
	else
		c=`df  |  awk ' { 
				for ( i=1; i <= NF ; i++) {
					if ( (length($i) == 1) && ($i == "/") ) {
						print i; 
						exit;
					}
			}
		 } '`
		ifs=`echo $IFS`
		IFS='
		'
		for i in  `df  | awk '{ print $c }'  c=$c 2>/dev/null` 
			do
				 if [ \( ! -z "$i"  -a  -d "$i" \) ] ; then
						partitions=`awk 'END{ s=sprintf("%s,%s", i,p); print s }' i="$i" p="$partitions" </dev/null 2>/dev/null`
				 fi 
			done
		IFS="$ifs"
		echo "$partitions" | sed 's/,$//'
	fi 
}

#FileService
getPartitionFreeSpace()
{
df -P --block-size=512 "$2" 2>/dev/null 1>&2 
if [ $? -eq 0 ] ; then
	# Linux df is POSIX complaint
	df -P --block-size=512 "$2" | awk ' NR > 1 { printf("%.f\n", $4* 512); }' 2>/dev/null
else 
	df -P "$2" 2>/dev/null 1>&2
	# If POSIX complaint
	if [ $? -eq 0 ] ; then 
		df  -P  "$2" | awk ' NR > 1 { printf("%.f\n", $4 * 512); } ' 2>/dev/null
	# Is Solaris xpg4 available
	elif  [ -x /usr/xpg4/bin/df ] ; then 
		/usr/xpg4/bin/df -P "$2"  | awk ' NR > 1 { printf("%.f\n", $4 * 512); }'  2>/dev/null
	else
	# if it comes this far, guess  the column 4 of df as free-available blocks. This may be incorrect
		df  "$2" | awk ' NR > 1 { printf("%.f\n", $4 * 512); }' 2>/dev/null
	fi
fi 
}

#FileService
getPartitionFormat()
{
	if [ -f /etc/fstab ] ; then  
	#BSD, HPUX, Linux
		cat /etc/fstab | awk '$2 == PARTITION { print $3 }' PARTITION="$2" 
	elif [ -f /etc/vfstab ] ; then 
	#Solaris
		cat /etc/vfstab | awk '$3 == PARTITION { print $4 }' PARTITION="$2" 
	elif [ -f /etc/filesystems ] ; then 
	# AIX 
		cat /etc/filesystems |
			sed 's/^[ 	]*//' |  
				awk ' BEGIN { 
									FS="=" 
								} 

								{   s=sprintf("%s:",p);
										if ( $0 == s ) { 
												f =1 ; 
												next
										} else  if ( f== 1 && $0 ~ /^\// )  {
											exit;
										}
								}

								{ if ( f==1 ) print $0 ;
								}' p="$1"  | awk '/^vfs/{ print $0 }' | sed 's/.*=//;s/^[ 	]*//'	
	else
		echo ERROR >&1
		echo "unable to find partition format for $1" 1>&2
	fi
}

#JVMService
calculateJVMInstallerSize()
{
	if [ -f "$2" ] ; then 
		tarfileSize=`uncompress -c "$2" | wc -c  | awk '{ if ( $1 ~ /^[0-9]/ ) print $1 ; else print 0; }' 2>/dev/null`
		#third column of 'tvf' option  lists file size in bytes. 
		#if entry = directory; then  filesize= 0.
		#assumed that each file would not finish in 512 block boundary. so always add on 512 block to each file entry
		#each directory entry takes 2 512 blocks. 
		uncompress -c "$2" | tar tvf -  | awk '{  if ($3 == 0) d=d+1; fs=fs+$3; } END{ if (b > fs) fs=b; cds1=fs; cds2=(NR-d)*a; cds3=2*d*a; r=cds1+cds2+cds3+a; print int(r); }' a=512 b="$cdstarfs"  2>/dev/null
	else
		echo ERROR >&1
		echo "$2 does not exist." 1>&2
	fi
}

isNumeric() 
{
	if  [ -n "$1" ] ; then 
		num=`echo "$1" | sed 's/[0-9]*//g' 2>/dev/null`
		case ${num} in  
		"") echo 0;;     
		 *) echo 1;; 
		esac
	else
		echo 1	
	fi 
}

#SecurityService
isCurrentUserAdmin()
{
	ID=`id | tr ' ' '\012' | grep '^uid' | sed 's/(.*)//' | awk 'BEGIN {FS="="} { print $2 }'`
	if [ `isNumeric "$ID"` -eq 0 ] ; then 
		if [ "$ID" -eq 0 ] ; then 
		 echo true
		else
		 echo false
		fi
	else
		type logname 2>/dev/null 1>&2
		if [ $? -eq 0 ] ; then 
			echo ERROR >&1
			echo "unable to find user status for `logname`" 1>&2
		else
			echo ERROR >&1
			echo "unable to find user status" 1>&2
		fi
	fi
}

#SecurityService
createUser()
{
	USER_SPEC="$2"
	USER_FULL_NAME=`echo "$USER_SPEC" | cut -d"+" -f1 | sed -e 's/\ /_/g'`
	USER_GROUPS=`echo "$USER_SPEC" | cut -d"+" -f2`
	USER_HOME=`echo "$USER_SPEC" | cut -d"+" -f3 | sed -e 's/\ /_/g'`
	
	DATE=`echo "$USER_SPEC" | cut -d"+" -f4`
	YEAR=`echo "$DATE" | cut -d"/" -f1`
	MONTH=`echo "$DATE" | cut -d"/" -f2`
	DAY=`echo "$DATE" | cut -d"/" -f3`
	HOUR=`echo "$DATE" | cut -d"/" -f4`
	MIN=`echo "$DATE" | cut -d"/" -f5`

	LOGIN_NAME=`echo "$USER_SPEC" | cut -d"+" -f5`

	if [ -x /usr/sbin/useradd ] ; then
		options=`awk 'END { if (index(A, "IS_NULL") == 0) 
																			s=sprintf("-c %s",A);  
																	if (index(B, "IS_NULL") == 0)
																			s=sprintf("%s -G %s",s, B);
																	if (index(C, "IS_NULL") == 0) 
																		s=sprintf("%s -d %s -m",s,C);
																	if (index(DATE, "IS_NULL") == 0)
																		s=sprintf("%s -e %s/%s/%s",s,M,D,Y);
																	print s 
																}' A="$USER_FULL_NAME" B="$USER_GROUPS" C="$USER_HOME" Y="$YEAR" M="$MONTH" D="$DAY" DATE="$DATE" </dev/null`
		eval "/usr/sbin/useradd $options $LOGIN_NAME"
		if [ $? -ne 0 ] ; then 
			echo ERROR >&1
			echo "error creating user $LOGIN_NAME" 1>&2
		else
			echo OK >&1
		fi
	elif [ -x /usr/sbin/adduser ] ; then 
		options=`awk 'END { if (index(A, "IS_NULL") == 0) 
																		s=sprintf("-c %s",A);  
																if (index(B, "IS_NULL") == 0) 
																		s=sprintf("%s -G %s",s, B);
																if (index(C, "IS_NULL") == 0)
																	s=sprintf("%s -d %s -m",s,C);
																if (index(DATE, "IS_NULL") == 0)
																	s=sprintf("%s -e %s/%s/%s",sY,M,D);
																print s 
															}' A="$USER_FULL_NAME" B="$USER_GROUPS" C="$USER_HOME" Y="$YEAR" M="$MONTH" D="$DAY" DATE="$DATE" </dev/null`
		eval "/usr/sbin/adduser $options $LOGIN_NAME"
		if [ $? -ne 0 ] ; then 
			echo ERROR >&1
			echo "error creating user $LOGIN_NAME" 1>&2
		else
			echo OK >&1
		fi
	elif [ -x /usr/bin/mkuser ] ; then 
		options=`awk 'END { 	
						if (index(A, "IS_NULL") == 0) 	{ 
								s=sprintf("gecos=%s",A);   
							}
						if (index(B, "IS_NULL") == 0) { 
							s=sprintf("%s groups=%s",s, B); 
						}
						if (index(C, "IS_NULL") == 0) { 
							s=sprintf("%s home=%s",s,C); 
						}
						if (index(DATE, "IS_NULL") == 0) {
							y=substr(Y,3,2);
							s=sprintf("%s expires=%s%s%s%s%s",s,M,D,H,MN,y);
					}
					print s;
			}' A="$USER_FULL_NAME" B="$USER_GROUPS" C="$USER_HOME" Y="$YEAR" M="$MONTH" D="$DAY" DATE="$DATE" H="$HOUR" MN="$MIN" </dev/null`
		eval "/usr/bin/mkuser $options $LOGIN_NAME"
		if [ $? -ne 0 ] ; then
			echo ERROR >&1
			echo "error creating user $LOGIN_NAME" 1>&2
		else
			echo OK >&1
		fi
	 else 
			echo ERROR >&1
			echo "error creating user $LOGIN_NAME" 1>&2
	fi
}

#SecurityService
deleteUser()
{
	if [ -x /usr/sbin/userdel ] ; then
		/usr/sbin/userdel -r "$2"
		if [ $? -ne 0 ] ; then 
			echo ERROR >&1
			echo "error deleting user $2" 1>&2
		else
			echo OK >&1
		fi
	elif [ -x /usr/sbin/rmuser ] ; then 
		/usr/sbin/rmuser -p "$2"
		if [ $? -ne 0 ] ; then 
			echo ERROR >&1
			echo "error deleting user $2" 1>&2
		else
			echo OK >&1
		fi
	else 
		echo ERROR >&1
		echo "error deleting user $2" 1>&2
	fi
}

#SecurityService
createGroup()
{
	if [ -x /usr/sbin/groupadd ] ; then 
		/usr/sbin/groupadd "$2"
		if [ $? -ne 0 ] ; then
			echo ERROR >&1
			echo "error adding group $2" 1>&2
		else
			echo OK >&1
		fi
	elif [ -x /usr/bin/mkgroup ] ; then 
		/usr/bin/mkgroup "$2"
		if [ $? -ne 0 ] ; then
			echo ERROR >&1
			echo "error adding group $2" 1>&2
		else
			echo OK >&1
		fi
	else
		echo ERROR >&1
		echo "error creating group $1" 1>&2
	fi
}

#SecurityService
deleteGroup()
{
	if [ -x /usr/sbin/groupdel ] ; then
		/usr/sbin/groupdel "$2"
		if [ $? -ne 0 ] ; then
			echo ERROR >&1
			echo "error deleting group $2" 1>&2
		else
			echo OK >&1
		fi
	elif [ -x /usr/sbin/rmgroup ] ; then 
		/usr/sbin/rmgroup "$2"
		if [ $? -ne 0 ] ; then
			echo ERROR >&1
			echo "error deleting group $2" 1>&2
		else
			echo OK >&1
		fi
	else
		echo ERROR >&1
		echo "error deleting group $1" 1>&2
	fi
}

locateExecutable()
{
	type "$2" >/dev/null 2>&1
	if [ $? -eq 0 ] ; then
		type "$2" | awk ' { print $3 } '
	else
		echo ERROR >&1
		echo "$2 not found" 1>&2
	fi
}

#SystemUtil
getEnvironmentVariable()
{
	II=`echo "$2" | sed 's/\(.*\)/$\1/'`
	eval II=$II
	echo $II
}

main()
{
	function="$1"
	$function "$@"
}
_XPG=1
BIN_SH=xpg4
# basic handshake between shell script process spawned by Java and shell interface utitlity. 
echo "829498192872947" # some randon numbers.
echo 1  # sequence of version supported. 
while [ -n "nostop"   ] ;
do
	read functionname arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg9 arg10 arg11 arg12
	 if [  "$functionname" != stop  ] ;  then
		eval "$functionname" dummy "$arg1" "$arg2" "$arg3" "$arg4" "$arg5" "$arg6" "$arg7" "$arg9" "$arg10" "$arg11" "$arg12"
	 else
		exit 0;
	 fi
done
