#!/bin/sh
# InstallShield (R)
# (c)2005, Macrovision Corporation
# (c)1996-2003, InstallShield Software Corporation
# (c)1990-1996, InstallShield Corporation
# All Rights Reserved.

main()
{
	Initialize
	while  getopts F:R:da:t:h  c
	do
		case $c in
			F) FILELIST="$OPTARG";;
			R) DIRLIST="$OPTARG";;
			d) DEBUG=1;;
			a) ATTEMPTS="$OPTARG";;
			t) DELAY="$OPTARG";;
			h) Usage;;
		esac
	done
	shift `expr $OPTIND - 1`
	if [ "$DEBUG" -eq 1  ] ; then 
		exec 2>&1 1>$HOME/gulf.log
	fi 
delete
}
 
Initialize()
{
	DEBUG=0
	ATTEMPTS=10
	DELAY=10
	STATUS=more
	DIRSORT=null
	FILESORT=null
}

dbg()
{
	if [ "$DEBUG" -eq 1 ] ; then 
		echo "$1"
	fi
}

Usage()
{
	echo "gulf -F <FileList.txt> -D <DirList.txt> [-d ] [ -a <no of attempt> ] [ -t <delay in seconds> ] [ -h ] "
	exit 1
}

delete()
{
	cd $HOME
	if [ -f "$DIRLIST" ] ; then
		DIRSORT=$HOME/`basename $DIRLIST`.sorted
		dbg "creating DIRSORT($DIRSORT)"
		sort -r "$DIRLIST" > "$DIRSORT"
	fi
	if [ -f "$FILELIST" ] ; then
		FILESORT=$HOME/`basename $FILELIST`.sorted
		dbg "creating FILESORT($FILESORT)"
		sort -r "$FILELIST" > "$FILESORT"
	fi
	dbg "HOME=$HOME"
	dbg "DIRLIST=$DIRLIST"
	dbg "FILELIST=$FILELIST"
	dbg "DIRSORT=$DIRSORT"
	dbg "FILESORT=$FILESORT"
	dbg "DEBUG=$DEBUG"
	dbg "ATTEMPTS=$ATTEMPTS"
	dbg "DELAY=$DELAY"
	while [ "$STATUS" != done ] ; do
		STATUS=done
		if [  -f "$DIRSORT" ] ; then 
			dbg "cleaning up DIRSORT"
			dirlistc=`wc -l "$DIRSORT" | awk '{ print $1 }'`
			dirlistcc=1
			while [ $dirlistcc -le $dirlistc ] ; do
					dirlistl=`sed -n -e "${dirlistcc}p" "$DIRSORT"`
					if [ -d "$dirlistl" ] ; then 
						dbg "deleting $dirlistl"
						rm -fr "$dirlistl" > /dev/null 2>&1
						if [ $? -ne 0 ] ; then 
							dbg "could not delete directory $dirlistl"
							STATUS=more
						fi
					fi 
			dirlistcc=`expr $dirlistcc + 1`
			done
			dbg "done cleaning up DIRSORT"
		fi 

		if [  -f "$FILESORT" ] ; then 
			dbg "cleaning up FILESORT"
			filelistc=`wc -l "$FILESORT" | awk '{ print $1 }'`
			filelistcc=1
			while [ $filelistcc -le $filelistc ] ; do
				filelistl=`sed -n -e "${filelistcc}p" "$FILESORT"`
				if [ -d "$filelistl" ] ; then 
					dbg "deleting $filelistl (dir)"
					rmdir "$filelistl" > /dev/null 2>&1
					if [ $? -ne 0 ] ; then 
						STATUS=more
					fi
				elif [ -f "$filelistl" ] ; then 
					dbg "deleting $filelistl (file)"
					rm -f "$filelistl" > /dev/null 2>&1 
					if [ $? -ne 0 ] ; then 
						STATUS=more
					fi
				fi
			filelistcc=`expr $filelistcc +  1`
			done
			dbg "done cleaning up FILESORT"
		fi 
		
		if [ "$STATUS" =  more ] ; then 
			ATTEMPTS=`expr $ATTEMPTS - 1`
			dbg "no of attempts remaining = $ATTEMPTS" 
			if [ $ATTEMPTS -eq 0 ] ; then 
				STATUS=done
			else
				dbg "sleeping for $DELAY seconds" 
				sleep $DELAY
			fi
		fi 
	done
	if [ "$DEBUG" -ne 1 ] ; then 
		rm -f $FILESORT
		rm -f $DIRSORT
	fi
	PARENT=`dirname "$0"`
	if [ -f "$0" ] ; then 
		rm -f "$0"
	fi

	isTemp=`awk 'END { if (length(a) > 1 &&  index(a,"ismp") > 1) { print 1 } else { print 0} }' a="$PARENT" </dev/null  2>/dev/null`
	if [ "$isTemp" -eq 1 ] ; then  
			if [ -d "$PARENT" ] ; then 
				rm -fr "$PARENT"
			fi 
	fi  
}

main "$@"
