#!/bin/sh

PATH=/sbin:/usr/sbin:/usr/bin:/bin:$DOLLAR$PATH ; export PATH
unalias -a > /dev/null 2>&1

MACHINE=`uname`

LICENSE_USER="$USER_INPUT_ACCOUNT_NAME$"

# get primary group
id $LICENSE_USER > /dev/null 2>&1
if [ $? -eq 0 ];
then
    LICENSE_USER_PRIMARY_GROUP=`id $LICENSE_USER | cut -d" " -f2 | cut -d"(" -f2 | cut -d")" -f1`
else
    echo "Could not determine primary group for $LICENSE_USER"
    exit 1
fi

# change ownership
if [ ! -z "$LICENSE_USER_PRIMARY_GROUP" ];
then
    chown -R $LICENSE_USER:$LICENSE_USER_PRIMARY_GROUP "$USER_INSTALL_DIR$"
else
    echo "Could not set ownership"
    exit 1
fi
