#!/bin/sh
PATH=/sbin:/usr/sbin:/usr/bin:/bin:$DOLLAR$PATH ; export PATH

unalias -a >/dev/null 2>&-
MACHINE=`uname`

#TODO in future use Java code to identify exactly which files to delete

#delete all RCs, soft links, plist, etc.
if [ $OLD_INSTALL_VERSION$ -gt 4 ]
then
    case $MACHINE in      
        HP*) # HP-UX Machine.
            find /sbin/rc3.d/ -name 'K*$DAEMON_NAME$' -type l -exec rm -f {} \;
            find /sbin/rc3.d/ -name 'S*$DAEMON_NAME$' -type l -exec rm -f {} \;
            find /sbin/init.d/ -name '$DAEMON_NAME$' -exec rm -f {} \;
        ;;
        AIX) #IBM AIX Machine.
            find /etc/rc.d/rc2.d/ -name 'K*$DAEMON_NAME$' -type l -exec rm -f {} \;
            find /etc/rc.d/rc2.d/ -name 'S*$DAEMON_NAME$' -type l -exec rm -f {} \;
            find /etc/rc.d/ -name '$DAEMON_NAME$' -exec rm -f {} \;
        ;;
        SunOS) # Machine type SUN Solaris.
            find /etc/rc3.d/ -name 'K*$DAEMON_NAME$' -type l -exec rm -f {} \;
            find /etc/rc3.d/ -name 'S*$DAEMON_NAME$' -type l -exec rm -f {} \;
            find /etc/init.d/ -name '$DAEMON_NAME$' -exec rm -f {} \;
        ;;        
        *) # All other platforms
            if [ -f /etc/rc.d/init.d/$DAEMON_NAME$ ] 
            then
              find /etc/rc.d/ -name 'K*$DAEMON_NAME$' -type l -exec rm -f {} \;
              find /etc/rc.d/ -name 'S*$DAEMON_NAME$' -type l -exec rm -f {} \;
              rm -f /etc/rc.d/init.d/$DAEMON_NAME$
            else
              find /etc/init.d/ -name 'K*$DAEMON_NAME$' -type l -exec rm -f {} \;     
              find /etc/init.d/ -name 'S*$DAEMON_NAME$' -type l -exec rm -f {} \;   
              rm -f /etc/init.d/$DAEMON_NAME$
            fi           
        ;;
    esac
else
    case $MACHINE in     
        HP*) # HP-UX Machine.
            find /sbin/rc3.d/ -name 'K*rc.ugs.licensing' -type l -exec rm -f {} \;
            find /sbin/rc3.d/ -name 'S*rc.ugs.licensing' -type l -exec rm -f {} \;
            find /sbin/init.d/ -name 'rc.ugs.licensing' -exec rm -f {} \;
        ;;
        AIX) #IBM AIX Machine.
            find /etc/rc.d/rc2.d/ -name 'K*rc.ugs.licensing' -type l -exec rm -f {} \;
            find /etc/rc.d/rc2.d/ -name 'S*rc.ugs.licensing' -type l -exec rm -f {} \;
            find /etc/rc.d/ -name 'rc.ugs.licensing' -exec rm -f {} \;
        ;;
        SunOS) # Machine type SUN Solaris.
            find /etc/rc3.d/ -name 'K*rc.ugs.licensing' -type l -exec rm -f {} \;
            find /etc/rc3.d/ -name 'S*rc.ugs.licensing' -type l -exec rm -f {} \;
            find /etc/init.d/ -name 'rc.ugs.licensing' -exec rm -f {} \;
        ;;        
        *) # All other platforms
            if [ `find /etc/rc.d/ -name '*rc.ugs.licensing' | wc -l` -gt 0 ]
            then
              find /etc/rc.d/ -name 'K*rc.ugs.licensing' -type l -exec rm -f {} \;
              find /etc/rc.d/ -name 'S*rc.ugs.licensing' -type l -exec rm -f {} \;
              find /etc/rc.d/ -name 'rc.ugs.licensing' -exec rm -f {} \;
            fi  
            
            if [ `find /etc/init.d/ -name '*rc.ugs.licensing' | wc -l` -gt 0 ]
            then
              find /etc/init.d/ -name 'K*rc.ugs.licensing' -type l -exec rm -f {} \;
              find /etc/init.d/ -name 'S*rc.ugs.licensing' -type l -exec rm -f {} \;
              find /etc/init.d/ -name 'rc.ugs.licensing' -exec rm -f {} \;
            fi
        ;;
    esac
fi