#!/bin/sh
PATH=/sbin:/usr/sbin:/usr/bin:/bin:$DOLLAR$PATH ; export PATH

unalias -a > /dev/null 2>&1

MACHINE=`uname`

LICENSE_USER="$USER_INPUT_ACCOUNT_NAME$"
LICENSE_GROUP="$DEFAULT_LICENSE_GROUP$"
FULLNAME="Siemens PLM License Server"

ret_val=1

case $MACHINE in
    Darwin)
        # calculate next UID and GID
        unset -v i NEW_UID NEW_GID IDVAR
        declare -i NEW_UID=0 NEW_GID=0 i=500 IDVAR=0
        while [[ $IDVAR -eq 0 ]]; do 
            i=$[i+1]
            if [[ -z "$(/usr/bin/dscl . -search /Users uid $i)" ]] && [[ -z "$(/usr/bin/dscl . -search /Groups gid $i)" ]]; then
                NEW_UID=$i
                NEW_GID=$i
                IDVAR=1
            fi
        done
        
        # verify UID and GID
        if [[ $NEW_UID -eq 0 ]] || [[ $NEW_GID -eq 0 ]]; then
            echo "Getting unique id numbers (uid, gid) failed!"
            exit 1
        fi
        
        # now create the user's primary group        
        dscl . -create "/Groups/$LICENSE_GROUP"
        dscl . -append "/Groups/$LICENSE_GROUP" gid $NEW_GID
        dscl . -append "/Groups/$LICENSE_GROUP" passwd "*"
        
        # create the primary user
        dscl . -create "/Users/$LICENSE_USER"
        dscl . -append "/Users/$LICENSE_USER" RealName "$FULLNAME"
        dscl . -append "/Users/$LICENSE_USER" NFSHomeDirectory "/var/empty"
        dscl . -append "/Users/$LICENSE_USER" UserShell /usr/bin/false
        dscl . -append "/Users/$LICENSE_USER" PrimaryGroupID $NEW_GID
        dscl . -append "/Users/$LICENSE_USER" UniqueID $NEW_UID
        
        dscl . -append "/Groups/$LICENSE_GROUP" GroupMembership "$LICENSE_USER"
    ;;
    HP*)
        # create new group
        groupadd "$LICENSE_GROUP"
        
        # create new user        
        useradd -g "$LICENSE_GROUP" -c "$FULLNAME" "$LICENSE_USER"
    ;;
    Sun*)
        # create new group
        groupadd "$LICENSE_GROUP"
        
        # create new user
        useradd -g "$LICENSE_GROUP" -c "$FULLNAME" "$LICENSE_USER"
        
        # make user no-login
        passwd -N "$LICENSE_USER"
    ;;
    AIX)
        # create new group
        mkgroup "$LICENSE_GROUP"
        
        # create new user
        mkuser home=/tmp login=false admin=false daemon=true "$LICENSE_USER"
        chuser "pgrp=$LICENSE_GROUP" "$LICENSE_USER"
        chuser "groups=" $LICENSE_GROUP
        chuser "rlogin=false" "$LICENSE_USER"
        chuser "gecos=$FULLNAME" "$LICENSE_USER"
    ;;
    Linux)
        # create new group
        groupadd "$LICENSE_GROUP"
        
        # create new user
        useradd -g "$LICENSE_GROUP" -M -s /sbin/nologin -c "$FULLNAME" "$LICENSE_USER"        
    ;;
esac
    