#!/bin/sh

PATH=/sbin:/usr/sbin:/usr/bin:/bin:$DOLLAR$PATH ; export PATH

unalias -a > /dev/null 2>&1

#Machine name
MACHINE=`uname`

#if standard scripts fail try to do it the hard way
for PROCESS in "$OLD_INSTALL_DIR$/lmgrd" ugslmd
do
    case $MACHINE in
        Darwin) #Machine type Apple Mac OS.
            ps -A | grep -v grep | grep "${PROCESS}" > /dev/null && {
                #Found the process so do this
                set -- `ps -A | grep -v grep | grep "${PROCESS}"`
                kill -9 $1 >/dev/null 2>&-             
                sleep 2
            }            
        ;;
        *) #All other platforms
            ps -ef | grep -v grep | grep "${PROCESS} " > /dev/null && {
                set -- `ps -ef | grep -v grep | grep "${PROCESS}"`
                kill -9 $2 > /dev/null 2>&- #Hard kill it
                sleep 2                     #anyway as this script is internally used during installation,
                                            #and is used as a last resort to stop a service  
                [ "$PROCESS" = "ugslmd" ] && {
                    kill -9 $3 > /dev/null 2>&-
                    sleep 2
                }              
            }
        ;;
    esac
done
