#!/bin/sh
PATH=/sbin:/usr/sbin:/usr/bin:/bin:$DOLLAR$PATH ; export PATH

unalias -a > /dev/null 2>&1

MACHINE=`uname`
ACCOUNT=$USER_INPUT_ACCOUNT_NAME$

ret_val=1

case $MACHINE in
    Darwin)
        # On Mac OS just return success assuming that the user can be accessed
        # because sudo may timeout by the time this command is executed
        #sudo -u "$ACCOUNT" "/bin/echo" SUCCESS
        ret_val=0
    ;;
    Linux)
        su "$ACCOUNT" -s /bin/sh -c "echo User $ACCOUNT Test Passed..."
        ret_val=$?
    ;;
    *)
        su "$ACCOUNT" -c "echo SUCCESS"
        ret_val=$?
    ;;
esac

exit $ret_val