[Setup]
AppName=OfficeRecovery 2013 Ultimate 
AppVerName=OfficeRecovery 2013 Ultimate v13.0.40450 RU-BOARD Edition
DefaultDirName={pf}\OfficeRecovery 2013 Ultimate
DefaultGroupName=OfficeRecovery 2013 Ultimate
OutputDir=C:\Output
;Compression=none
OutputBaseFilename=OfficeRecovery.2013.Ultimate-RBC
DisableProgramGroupPage=yes
Compression=lzma2/ultra64
SolidCompression=yes
InternalCompressLevel=ultra64
Uninstallable=yes                    
DirExistsWarning=no
DisableReadyPage=no                       
AllowNoIcons=yes                              
WizardImageFile=C:\sshot.bmp
UninstallLogMode=overwrite                        
PrivilegesRequired=admin
VersionInfoCompany=RBC 
VersionInfoCopyright=Kindly 
VersionInfoDescription=Special for Ru-Board      
SetupIconFile=C:\orm.ico
             
[Messages]
BeveledLabel=- Done by Kindly. 10x to Jedi for help. RBC!

[Files]
Source: "c:\Repack\Main\OfficeRecovery\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs sortfilesbyextension
Source: "c:\Repack\OfficeRecovery.d7cc0641\*"; DestDir: "{commonappdata}\{code:InstallLicPath}"; Flags: ignoreversion recursesubdirs createallsubdirs sortfilesbyextension

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; 

[Icons]
Name: "{group}\Free Undelete"; Filename: "{app}\fru\fru.exe"; WorkingDir: "{app}\fru"; IconFilename: "{app}\fru\fru.ico"
Name: "{group}\MediaHeal for CD and DVD"; Filename: "{app}\mhc\mhc.exe"; WorkingDir: "{app}\mhc"; IconFilename: "{app}\mhc\mhc.ico"
Name: "{group}\MediaHeal for Diskettes"; Filename: "{app}\mhi\mhi.exe"; WorkingDir: "{app}\mhi"; IconFilename: "{app}\mhi\mhi.ico"
Name: "{group}\MediaHeal for Flash"; Filename: "{app}\mhf\mhf.exe"; WorkingDir: "{app}\mhf"; IconFilename: "{app}\mhf\mhf.ico"
Name: "{group}\MediaHeal for Hard Drives"; Filename: "{app}\mhd\mhd.exe"; WorkingDir: "{app}\mhd"; IconFilename: "{app}\mhd\mhd.ico"
Name: "{group}\MediaHeal for Removable Disks"; Filename: "{app}\mhr\mhr.exe"; WorkingDir: "{app}\mhr"; IconFilename: "{app}\mhr\mhr.ico"
Name: "{group}\PixRecovery"; Filename: "{app}\pir\pir.exe"; WorkingDir: "{app}\pir"; IconFilename: "{app}\pir\pir.ico"
Name: "{group}\Recovery for Access"; Filename: "{app}\ar\ar.exe"; WorkingDir: "{app}\ar"; IconFilename: "{app}\ar\ar.ico"
Name: "{group}\Recovery for Backup"; Filename: "{app}\bkr\bkr.exe"; WorkingDir: "{app}\bkr"; IconFilename: "{app}\bkr\bkr.ico"
Name: "{group}\Recovery for Calc"; Filename: "{app}\ooc\ooc.exe"; WorkingDir: "{app}\ooc"; IconFilename: "{app}\ooc\ooc.ico"
Name: "{group}\Recovery for Excel"; Filename: "{app}\xr\xr.exe"; WorkingDir: "{app}\xr"; IconFilename: "{app}\xr\xr.ico"
Name: "{group}\Recovery for Money"; Filename: "{app}\mr\mr.exe"; WorkingDir: "{app}\mr"; IconFilename: "{app}\mr\mr.ico"
Name: "{group}\Recovery for OneNote"; Filename: "{app}\onr\onr.exe"; WorkingDir: "{app}\onr"; IconFilename: "{app}\onr\onr.ico"
Name: "{group}\Recovery for Outlook Express"; Filename: "{app}\oer\oer.exe"; WorkingDir: "{app}\oer"; IconFilename: "{app}\oer\oer.ico"
Name: "{group}\Recovery for Outlook"; Filename: "{app}\olr\olr.exe"; WorkingDir: "{app}\olr"; IconFilename: "{app}\olr\olr.ico"
Name: "{group}\Recovery for PDF"; Filename: "{app}\pdf\pdf.exe"; WorkingDir: "{app}\pdf"; IconFilename: "{app}\pdf\pdf.ico"
Name: "{group}\Recovery for Photoshop"; Filename: "{app}\psr\psr.exe"; WorkingDir: "{app}\psr"; IconFilename: "{app}\psr\psr.ico"
Name: "{group}\Recovery for PowerPoint"; Filename: "{app}\ppr\ppr.exe"; WorkingDir: "{app}\ppr"; IconFilename: "{app}\ppr\ppr.ico"
Name: "{group}\Recovery for Project"; Filename: "{app}\prr\prr.exe"; WorkingDir: "{app}\prr"; IconFilename: "{app}\prr\prr.ico"
Name: "{group}\Recovery for Publisher"; Filename: "{app}\pbr\pbr.exe"; WorkingDir: "{app}\pbr"; IconFilename: "{app}\pbr\pbr.ico"
Name: "{group}\Recovery for QuickBooks"; Filename: "{app}\qbr\qbr.exe"; WorkingDir: "{app}\qbr"; IconFilename: "{app}\qbr\qbr.ico"
Name: "{group}\Recovery for Windows Registry"; Filename: "{app}\reg\reg.exe"; WorkingDir: "{app}\reg"; IconFilename: "{app}\reg\reg.ico"
Name: "{group}\Recovery for Word"; Filename: "{app}\wr\wr.exe"; WorkingDir: "{app}\wr"; IconFilename: "{app}\wr\wr.ico"
Name: "{group}\Recovery for Word Perfect"; Filename: "{app}\wpr\wpr.exe"; WorkingDir: "{app}\wpr"; IconFilename: "{app}\wpr\wpr.ico"
Name: "{group}\Recovery for Works Database"; Filename: "{app}\wkd\wkd.exe"; WorkingDir: "{app}\wkd"; IconFilename: "{app}\wkd\wkd.ico"
Name: "{group}\Recovery for Works Spreadsheer"; Filename: "{app}\wkx\wkx.exe"; WorkingDir: "{app}\wkx"; IconFilename: "{app}\wkx\wkx.ico"
Name: "{group}\Recovery for Works Word"; Filename: "{app}\wkw\wkw.exe"; WorkingDir: "{app}\wkw"; IconFilename: "{app}\wkw\wkw.ico"
Name: "{group}\Recovery for Writer"; Filename: "{app}\oow\oow.exe"; WorkingDir: "{app}\oow"; IconFilename: "{app}\oow\oow.ico"
Name: "{group}\Undelete for Outlook"; Filename: "{app}\uol\uol.exe"; WorkingDir: "{app}\uol"; IconFilename: "{app}\uol\uol.ico"
Name: "{group}\Zip Recovery"; Filename: "{app}\zr\zr.exe"; WorkingDir: "{app}\zr"; IconFilename: "{app}\zr\zr.ico"

Name: "{group}\Advanced\Multiple File Repair Wizard"; Filename: "{app}\orm\orm.exe"; WorkingDir: "{app}\orm"; IconFilename: "{app}\orm\orm.ico"

Name: "{group}\Uninstall OfficeRecovery 2013 Ultimate"; Filename: "{uninstallexe}"; WorkingDir: "{app}"; IconFilename: "{app}\unins.ico"

Name: "{userdesktop}\OfficeRecovery 2013 Ultimate"; Filename: "{group}"; WorkingDir: "{group}"; Tasks: desktopicon; IconFilename: "{app}\olr\olr.ico"

[Code]
const
  bidDelAll = 1;
  bidSkipAll = 2;
                                                                                                              
var
  Form: TSetupForm;

  CheckListBox: TNewCheckListBox;
  AllButton, UnAllButton, OpenButton: TButton;
  DelButton, InvertButton: TButton;

  MsgForm: TSetupForm;
  MsgAllButton, MsgSkipAllButton: TButton;
  MsgCancelButton, MsgDelButton: TButton;

  DelAllReadOnly: Boolean;
  SkipAllReadOnly: Boolean;

  StaticText: TNewStaticText;
  Res: Integer;
  DataDirPage: TInputDirWizardPage;
  dir_name,MD5:string;

function InstallLicPath(Param: String): String;
begin
     dir_name := Lowercase(ExtractFileName(ExpandConstant('{app}')))
     MD5 := GetMD5OfString(dir_name);
     Delete(MD5, 9, 24)
     MD5 :=  ExtractFileName(ExpandConstant('{app}')) + '.' + MD5;
     Result:=MD5;
end;


function NextButtonClick(CurPage: Integer): Boolean;
var
  s, s2:string;
begin
  Result:=True;
  If CurPage=6
 then
begin
  s2:=ExpandConstant('{app}')+'';
  If DirExists(s2)
 then
begin
  s:='Installation in existing folder is not possible!';
  MsgBox(s, mbError, mb_Ok);
  Result:=False;
end;
 end else
begin
  Result:=True;
  If CurPage=wpReady
 then
begin
  s2:=ExpandConstant('{app}')+'';
  If DirExists(s2)
 then
begin
  s:='Congratulations! You find setup easter egg.'#13#13 +
  'Installation in existing folder is not possible!';
  MsgBox(s, mbCriticalError, mb_Ok);
  Result:=False;
end;
end;
end;
end;


function Size64(Hi, Lo: integer): Extended;
var
  i: integer;
begin
  Result:= Lo;
  if Lo < 0 then
    Result:= Result + 2147483647 + 2147483647 + 2;
  i:= Hi;
  while i > 0 do
    begin
      Result:= Result + 2147483647 + 2147483647 + 2;
      i:= i - 1;
    end;
end;

procedure FillListBox(const fromDir, fileMask: string; Level: Byte);
var
  FSR, DSR: TFindRec;
  FindResult: Boolean;
  APath: string;
  i: integer;
begin
  APath := AddBackslash(fromDir);
  FindResult := FindFirst(APath + fileMask, FSR);
  try
    while FindResult do
    begin
      if FSR.Attributes and FILE_ATTRIBUTE_DIRECTORY = 0 then
        begin
  {files} i:= CheckListBox.AddCheckBox(FSR.Name,
                  FloatToStr(Size64(FSR.SizeHigh, FSR.SizeLow)) + ' bytes',
                  Level, True, True, False, True, TStringList.Create);
          TStrings(CheckListBox.ItemObject[i]).Text:= APath + FSR.Name;
        end;
      FindResult := FindNext(FSR);
    end;
    FindResult := FindFirst(APath + '*.*', DSR);
    while FindResult do
    begin
      if ((DSR.Attributes and FILE_ATTRIBUTE_DIRECTORY) = FILE_ATTRIBUTE_DIRECTORY) and
        not ((DSR.Name = '.') or (DSR.Name = '..')) then
          begin
      {dir} i:= CheckListBox.AddCheckBox(DSR.Name,'DIR', Level,
                  True, True, False, True, TStringList.Create);
            TStrings(CheckListBox.ItemObject[i]).Text:= APath + DSR.Name;
{Recursion} FillListBox(APath + DSR.Name, fileMask, Level+1);
          end;
      FindResult := FindNext(DSR);
    end;
  finally
    FindClose(FSR);
    FindClose(DSR);
  end;
end;

procedure ButtonOnClick(Sender: TObject);
begin
 Case TButton(Sender).Tag of
  0 : CheckListBox.CheckItem(0, coCheckWithChildren);
  1 : CheckListBox.CheckItem(0, coUncheck);
 end;
end;

function HasChildren(Box: TNewCheckListBox; ItemIndex: integer): Boolean;
begin
if (ItemIndex = Box.Items.Count - 1) or
(Box.ItemLevel[ItemIndex+1] <= Box.ItemLevel[ItemIndex]) then
Result:= False
else
Result:= True;
end;

procedure InvertOnClick(Sender: TObject);
var
i: integer;
begin
for i:= 1 to CheckListBox.Items.Count - 1 do
begin
if Not HasChildren(CheckListBox, i) then
CheckListBox.Checked[i]:= Not (CheckListBox.State[i] = cbChecked);
end;
end;

procedure OpenOnClick(Sender: TObject);
begin
if not ShellExec('open', ExpandConstant('{userappdata}')+'\OfficeRecovery', '', ExpandConstant('{userappdata}')+'\OfficeRecovery', SW_SHOWMAXIMIZED, ewNoWait, Res) then
 MsgBox('Error!' #13#13 'Folder was not found.', mbError, MB_OK);
end;

procedure OpenAppOnClick(Sender: TObject);
begin
if not ShellExec('open', ExpandConstant('{app}'), '', ExpandConstant('{app}'), SW_SHOWMAXIMIZED, ewNoWait, Res) then
 MsgBox('Error!' #13#13 'Folder was not found.', mbError, MB_OK);
end;

procedure MsgButtonOnClick(Sender: TObject);
begin
  Case TButton(Sender).Tag of
    bidDelAll : DelAllReadOnly:= True;
    bidSkipAll: SkipAllReadOnly:= True;
  end;
  MsgForm.Close;
end;

function DelMsgBox(FileName: string): Boolean;
var
  MsgLabel: TLabel;
begin
  MsgForm:= CreateCustomForm;
  MsgForm.ClientWidth := ScaleX(400);
  MsgForm.ClientHeight := ScaleY(120);
  MsgForm.Caption := 'Files to delete';
  MsgForm.BorderIcons := [biMinimize];
  MsgForm.BorderStyle := bsSingle;
  MsgForm.Center;

  MsgLabel := TLabel.Create(MsgForm);
  MsgLabel.Left := ScaleX(20);
  MsgLabel.Top := ScaleY(20);
  MsgLabel.Caption:= FileName + ' is protected file or directory!' + #10#10#13 +
                     'Do you want to delete the file with READONLY attribute?';
  MsgLabel.Parent := MsgForm;

  MsgAllButton := TButton.Create(MsgForm);
  MsgAllButton.Parent := MsgForm;
  MsgAllButton.Width := ScaleX(75);
  MsgAllButton.Height := ScaleY(23);
  MsgAllButton.Left := ScaleX(20);
  MsgAllButton.Top := MsgForm.ClientHeight - ScaleY(23 + 10);
  MsgAllButton.Caption := 'Delete All';
  MsgAllButton.Tag:= bidDelAll;
  MsgAllButton.OnClick := @MsgButtonOnClick;

  MsgSkipAllButton := TButton.Create(MsgForm);
  MsgSkipAllButton.Parent := MsgForm;
  MsgSkipAllButton.Width := ScaleX(75);
  MsgSkipAllButton.Height := ScaleY(23);
  MsgSkipAllButton.Left := MsgAllButton.Left + MsgAllButton.Width + ScaleX(10);
  MsgSkipAllButton.Top := MsgForm.ClientHeight - ScaleY(23 + 10);
  MsgSkipAllButton.Caption := 'Skip All';
  MsgSkipAllButton.Tag:= bidSkipAll;
  MsgSkipAllButton.OnClick := @MsgButtonOnClick;

  MsgCancelButton := TButton.Create(MsgForm);
  MsgCancelButton.Parent := MsgForm;
  MsgCancelButton.Width := ScaleX(75);
  MsgCancelButton.Height := ScaleY(23);
  MsgCancelButton.Left := MsgForm.ClientWidth - MsgCancelButton.Width - ScaleX(20);
  MsgCancelButton.Top := MsgForm.ClientHeight - ScaleY(23 + 10);
  MsgCancelButton.Caption := 'Skip';
  MsgCancelButton.ModalResult := mrCancel;

  MsgDelButton := TButton.Create(MsgForm);
  MsgDelButton.Parent := MsgForm;
  MsgDelButton.Width := ScaleX(75);
  MsgDelButton.Height := ScaleY(23);
  MsgDelButton.Left := MsgCancelButton.Left - MsgDelButton.Width - ScaleX(10);
  MsgDelButton.Top := MsgForm.ClientHeight - ScaleY(23 + 10);
  MsgDelButton.Caption := 'Delete';
  MsgDelButton.ModalResult := mrOk;

  MsgForm.ActiveControl:= MsgCancelButton;

  if MsgForm.ShowModal() = mrOk then
    Result:= True
  else
    Result:= False;
end;

procedure DeleteFiles();
var
  SR: TFindRec;
  i: integer;
  str: string;
  ResultCode: Integer;
begin
  DelAllReadOnly:= False;
  SkipAllReadOnly:= False;
  for i:= CheckListBox.Items.Count - 1 downto 0 do
    begin
      if CheckListBox.State[i] = cbChecked then
        begin
          str:= Trim(TStrings(CheckListBox.ItemObject[i]).Text);
          FindFirst(str, SR);
          if ((SR.Attributes and FILE_ATTRIBUTE_READONLY) = FILE_ATTRIBUTE_READONLY) then
            if Not (DelAllReadOnly or SkipAllReadOnly) then
              if DelMsgBox(SR.Name) then
                Exec('attrib', ' -h -s -r ' + '"' + str + '"',
                  '', SW_HIDE, ewWaitUntilTerminated, ResultCode);
            if DelAllReadOnly then
                Exec('attrib', ' -h -s -r ' + '"' + str + '"',
                  '', SW_HIDE, ewWaitUntilTerminated, ResultCode);

          FindClose(SR);
          DeleteFile(str);
          RemoveDir(str);
        end;
    end;
end;

procedure BrowseRemainedFiles();
begin
  Form:= CreateCustomForm;
  Form.ClientWidth := ScaleX(496);
  Form.ClientHeight := ScaleY(360);
  Form.Caption := 'Uninstall - Remove Remaining Files';
  Form.BorderIcons := [biMinimize];
  Form.BorderStyle := bsSingle;
  Form.Center;

  StaticText := TNewStaticText.Create(Form);
  StaticText.Top := ScaleX(7);
  StaticText.Left:= ScaleX(10);
  StaticText.Caption := 'The following files were not removed because they were created after program was installed.'#13'Select any files that you want to delete and click Next to continue.';
  StaticText.AutoSize := True;
  StaticText.Parent := Form;

  CheckListBox := TNewCheckListBox.Create(Form);
  CheckListBox.Left:= ScaleX(10);
  CheckListBox.Top:= ScaleY(40);
  CheckListBox.Width:= Form.ClientWidth - ScaleX(10*2);
  CheckListBox.Height:= Form.ClientHeight - ScaleY(13*2 + 58);
  CheckListBox.Parent:= Form;
  CheckListBox.Offset:= 0;

  AllButton := TButton.Create(Form);
  AllButton.Parent := Form;
  AllButton.Width := ScaleX(75);
  AllButton.Height := ScaleY(23);
  AllButton.Left := ScaleX(10);
  AllButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  AllButton.Tag:= 0;
  AllButton.Caption := 'Select All';
  AllButton.OnClick := @ButtonOnClick;

  UnAllButton := TButton.Create(Form);
  UnAllButton.Parent := Form;
  UnAllButton.Width := ScaleX(75);
  UnAllButton.Height := ScaleY(23);
  UnAllButton.Left := AllButton.Left + AllButton.Width + ScaleX(7);
  UnAllButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  UnAllButton.Tag:= 1;
  UnAllButton.Caption := 'ClearAll';
  UnAllButton.OnClick := @ButtonOnClick;

  InvertButton := TButton.Create(Form);
  InvertButton.Parent := Form;
  InvertButton.Width := ScaleX(75);
  InvertButton.Height := ScaleY(23);
  InvertButton.Left := UnAllButton.Left + UnAllButton.Width + ScaleX(7);
  InvertButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  InvertButton.Caption := 'Invert';
  InvertButton.OnClick := @InvertOnClick;

  OpenButton := TButton.Create(Form);
  OpenButton.Parent := Form;
  OpenButton.Width := ScaleX(75);
  OpenButton.Height := ScaleY(23);
  OpenButton.Left := InvertButton.Left + InvertButton.Width + ScaleX(7);
  OpenButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  OpenButton.Caption := 'Explore';
  OpenButton.OnClick := @OpenAppOnClick;

  DelButton := TButton.Create(Form);
  DelButton.Parent := Form;
  DelButton.Width := ScaleX(75);
  DelButton.Height := ScaleY(23);
  DelButton.Left := Form.ClientWidth - DelButton.Width - ScaleX(10);
  DelButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  DelButton.Caption := 'Next >';
  DelButton.ModalResult := mrOk;

  CheckListBox.AddCheckBox(ExpandConstant('{app}'), '', 0, True, True, False, True, TStringList.Create);
  TStrings(CheckListBox.ItemObject[0]).Text:= ExpandConstant('{app}');
  FillListBox(ExpandConstant('{app}'), '*', 1);

  if Form.ShowModal() = mrOk then  DeleteFiles();
end;

procedure BrowseSavedFiles();
begin

  Form:= CreateCustomForm;
  Form.ClientWidth := ScaleX(496);
  Form.ClientHeight := ScaleY(360);
  Form.Caption := 'Uninstall - Removing OfficeRecovery Log Files';
  Form.BorderIcons := [biMinimize];
  Form.BorderStyle := bsSingle;
  Form.Center;

  StaticText := TNewStaticText.Create(Form);
  StaticText.Top := ScaleX(7);
  StaticText.Left:= ScaleX(10);
  StaticText.Caption := 'The following files were not removed because they were created after program was installed.'#13'Select any files that you want to delete and click Next to continue.';
  StaticText.AutoSize := True;
  StaticText.Parent := Form;

  CheckListBox := TNewCheckListBox.Create(Form);

  CheckListBox.Left:= ScaleX(10);
  CheckListBox.Top:= ScaleY(40);
  CheckListBox.Width:= Form.ClientWidth - ScaleX(10*2);
  CheckListBox.Height:= Form.ClientHeight - ScaleY(13*2 + 58);
  CheckListBox.Parent:= Form;
  CheckListBox.Offset:= 0;

  AllButton := TButton.Create(Form);
  AllButton.Parent := Form;
  AllButton.Width := ScaleX(75);
  AllButton.Height := ScaleY(23);
  AllButton.Left := ScaleX(10);
  AllButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  AllButton.Tag:= 0;
  AllButton.Caption := 'Select All';
  AllButton.OnClick := @ButtonOnClick;

  UnAllButton := TButton.Create(Form);
  UnAllButton.Parent := Form;
  UnAllButton.Width := ScaleX(75);
  UnAllButton.Height := ScaleY(23);
  UnAllButton.Left := AllButton.Left + AllButton.Width + ScaleX(7);
  UnAllButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  UnAllButton.Tag:= 1;
  UnAllButton.Caption := 'ClearAll';
  UnAllButton.OnClick := @ButtonOnClick;

  InvertButton := TButton.Create(Form);
  InvertButton.Parent := Form;
  InvertButton.Width := ScaleX(75);
  InvertButton.Height := ScaleY(23);
  InvertButton.Left := UnAllButton.Left + UnAllButton.Width + ScaleX(7);
  InvertButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  InvertButton.Caption := 'Invert';
  InvertButton.OnClick := @InvertOnClick;

  DelButton := TButton.Create(Form);
  DelButton.Parent := Form;
  DelButton.Width := ScaleX(75);
  DelButton.Height := ScaleY(23);
  DelButton.Left := Form.ClientWidth - DelButton.Width - ScaleX(10);
  DelButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  DelButton.Caption := 'Next >';
  DelButton.ModalResult := mrOk;

  OpenButton := TButton.Create(Form);
  OpenButton.Parent := Form;
  OpenButton.Width := ScaleX(75);
  OpenButton.Height := ScaleY(23);
  OpenButton.Left := InvertButton.Left + InvertButton.Width + ScaleX(7);
  OpenButton.Top := Form.ClientHeight - ScaleY(23 + 10);
  OpenButton.Caption := 'Explore';
  OpenButton.OnClick := @OpenOnClick;

  CheckListBox.AddCheckBox(ExpandConstant('{userappdata}')+'\OfficeRecovery', '', 0, True, True, False, True, TStringList.Create);
  TStrings(CheckListBox.ItemObject[0]).Text:= ExpandConstant('{userappdata}')+'\OfficeRecovery';
  FillListBox(ExpandConstant('{userappdata}')+'\OfficeRecovery', '*', 1);

  if Form.ShowModal() = mrOk then  DeleteFiles();
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
begin
if (CurUninstallStep = usPostUninstall) then
      begin
   if DirExists(ExpandConstant('{app}')) then
       BrowseRemainedFiles();
      begin
   if DirExists(ExpandConstant('{userappdata}')+'\OfficeRecovery') then
     BrowseSavedFiles();
end;
end;
end;