/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;

class ResultSetAccessor
extends Accessor {
    static final int maxLength = 16;

    ResultSetAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 102, 116, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    ResultSetAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 102, 116, s, false);
        this.initForDescribe(102, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 16;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    ResultSet getCursor(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        OracleStatement oracleStatement = this.statement.connection.RefCursorBytesToStatement(byArray, this.statement);
        oracleStatement.doDescribe(false);
        oracleStatement.prepareAccessors();
        OracleResultSetImpl oracleResultSetImpl = new OracleResultSetImpl(oracleStatement.connection, oracleStatement);
        oracleResultSetImpl.close_statement_on_close = true;
        oracleStatement.currentResultSet = oracleResultSetImpl;
        return oracleResultSetImpl;
    }

    Object getObject(int n) throws SQLException {
        return this.getCursor(n);
    }
}

