/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class TimestampAccessor
extends DateTimeCommonAccessor {
    TimestampAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 180, 180, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 180, 180, s, false);
        this.initForDescribe(180, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 11;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
            int n4 = 0;
            if (s == 11) {
                n4 = this.oracleNanos(n2);
            }
            string = n3 + "-" + this.rowSpaceByte[2 + n2] + "-" + this.rowSpaceByte[3 + n2] + "." + (this.rowSpaceByte[4 + n2] - 1) + "." + (this.rowSpaceByte[5 + n2] - 1) + ". " + (this.rowSpaceByte[6 + n2] - 1) + ". " + n4;
        }
        return string;
    }

    Object getObject(int n) throws SQLException {
        Serializable serializable = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            if (this.externalType == 0) {
                serializable = this.statement.connection.j2ee13Compliant ? this.getTimestamp(n) : this.getTIMESTAMP(n);
            } else {
                switch (this.externalType) {
                    case 93: {
                        return this.getTimestamp(n);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return serializable;
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getTIMESTAMP(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            tIMESTAMP = new TIMESTAMP(byArray);
        }
        return tIMESTAMP;
    }
}

