/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;

public class OracleJDBCRowSet
extends OracleRowSet
implements RowSet,
JdbcRowSet {
    private Connection connection;
    private static boolean driverManagerInitialized;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:47_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleJDBCRowSet() throws SQLException {
        driverManagerInitialized = false;
    }

    public OracleJDBCRowSet(Connection connection) throws SQLException {
        this();
        this.connection = connection;
    }

    @Override
    public void execute() throws SQLException {
        this.connection = this.getConnection(this);
        try {
            this.connection.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.setTypeMap(this.getTypeMap());
        if (this.preparedStatement == null) {
            this.preparedStatement = this.connection.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        }
        this.preparedStatement.setFetchSize(this.getFetchSize());
        this.preparedStatement.setFetchDirection(this.getFetchDirection());
        this.preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        this.preparedStatement.setMaxRows(this.getMaxRows());
        this.preparedStatement.setQueryTimeout(this.getQueryTimeout());
        this.preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        this.resultSet = this.preparedStatement.executeQuery();
        this.notifyRowSetChanged();
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
        this.notifyRowSetChanged();
        this.isClosed = true;
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        Connection connection;
        block10: {
            connection = null;
            if (this.connection != null && !this.connection.isClosed()) {
                connection = this.connection;
            } else if (rowSet.getDataSourceName() != null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    DataSource dataSource = (DataSource)initialContext.lookup(rowSet.getDataSourceName());
                    if (rowSet.getUsername() == null || rowSet.getPassword() == null) {
                        connection = dataSource.getConnection();
                        break block10;
                    }
                    connection = dataSource.getConnection(rowSet.getUsername(), rowSet.getPassword());
                }
                catch (NamingException namingException) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                }
            } else if (rowSet.getUrl() != null) {
                if (!driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    driverManagerInitialized = true;
                }
                String string = rowSet.getUrl();
                String string2 = rowSet.getUsername();
                String string3 = rowSet.getPassword();
                if (string.equals("") || string2.equals("") || string3.equals("")) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 301);
                }
                connection = DriverManager.getConnection(string, string2, string3);
            }
        }
        return connection;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new OracleRowSetMetaData(this.resultSet.getMetaData());
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    @Override
    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.getConnection(this);
        }
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.preparedStatement = this.connection.prepareStatement(string, this.getType(), this.getConcurrency());
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        super.setReadOnly(bl);
        if (this.connection != null) {
            this.connection.setReadOnly(bl);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        }
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        super.setFetchDirection(n2);
        this.resultSet.setFetchDirection(this.fetchDirection);
    }

    @Override
    public void setShowDeleted(boolean bl) throws SQLException {
        if (bl) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 303);
        } else {
            super.setShowDeleted(bl);
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl = this.resultSet.next();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean bl = this.resultSet.previous();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.resultSet.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.resultSet.afterLast();
            this.notifyCursorMoved();
        }
    }

    @Override
    public boolean first() throws SQLException {
        boolean bl = this.resultSet.first();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean last() throws SQLException {
        boolean bl = this.resultSet.last();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        boolean bl = this.resultSet.absolute(n2);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        boolean bl = this.resultSet.relative(n2);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    @Override
    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    @Override
    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        this.preparedStatement.setNull(n2, n3);
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        this.preparedStatement.setNull(n2, n3, string);
    }

    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.preparedStatement.setBoolean(n2, bl);
    }

    @Override
    public void setByte(int n2, byte by) throws SQLException {
        this.preparedStatement.setByte(n2, by);
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        this.preparedStatement.setShort(n2, s2);
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        this.preparedStatement.setInt(n2, n3);
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        this.preparedStatement.setLong(n2, l2);
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        this.preparedStatement.setFloat(n2, f2);
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        this.preparedStatement.setDouble(n2, d2);
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(n2, bigDecimal);
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        this.preparedStatement.setString(n2, string);
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.preparedStatement.setBytes(n2, byArray);
    }

    @Override
    public void setDate(int n2, Date date) throws SQLException {
        this.preparedStatement.setDate(n2, date);
    }

    @Override
    public void setTime(int n2, Time time) throws SQLException {
        this.preparedStatement.setTime(n2, time);
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        this.preparedStatement.setObject(n2, object);
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        this.preparedStatement.setRef(n2, ref);
    }

    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(n2, blob);
    }

    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        this.preparedStatement.setClob(n2, clob);
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        this.preparedStatement.setArray(n2, array);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.preparedStatement.setBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.preparedStatement.setTime(n2, time, calendar);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.preparedStatement.setTimestamp(n2, timestamp, calendar);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(n2, timestamp);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.preparedStatement.setAsciiStream(n2, inputStream, n3);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.preparedStatement.setCharacterStream(n2, reader, n3);
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.preparedStatement.setObject(n2, object, n3, n4);
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.preparedStatement.setObject(n2, object, n3);
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.preparedStatement.setDate(n2, date, calendar);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.resultSet.getObject(n2, map);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.resultSet.getBigDecimal(n2);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.resultSet.getRef(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.resultSet.getBlob(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.resultSet.getClob(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.resultSet.getArray(n2);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(n2, calendar);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        return this.resultSet.getCharacterStream(n2);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(n2, calendar);
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.resultSet.getBinaryStream(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(n2, calendar);
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this.resultSet.getString(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        return this.resultSet.getBoolean(n2);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        return this.resultSet.getByte(n2);
    }

    @Override
    public short getShort(int n2) throws SQLException {
        return this.resultSet.getShort(n2);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        return this.resultSet.getLong(n2);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        return this.resultSet.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        return this.resultSet.getDouble(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.resultSet.getBigDecimal(n2, n3);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this.resultSet.getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.resultSet.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.resultSet.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.resultSet.getTimestamp(n2);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.resultSet.getAsciiStream(n2);
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.resultSet.getUnicodeStream(n2);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        return this.resultSet.getInt(n2);
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        return this.resultSet.getObject(n2);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.resultSet.getBigDecimal(string, n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.resultSet.getBytes(string);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.resultSet.getTime(string);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.resultSet.getAsciiStream(string);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.resultSet.getUnicodeStream(string);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.resultSet.getObject(string);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.resultSet.getCharacterStream(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.resultSet.getObject(string, map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.resultSet.getRef(string);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.resultSet.getBlob(string);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.resultSet.getClob(string);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.resultSet.getArray(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.resultSet.getBigDecimal(string);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(string, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(string, calendar);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.resultSet.getBinaryStream(string);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(string, calendar);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.resultSet.getByte(string);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.resultSet.getShort(string);
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.resultSet.updateNull(n2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.resultSet.updateCharacterStream(n2, reader, n3);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(n2, timestamp);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.resultSet.updateBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.resultSet.updateAsciiStream(n2, inputStream, n3);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(n2, bl);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.resultSet.updateByte(n2, by);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.resultSet.updateShort(n2, s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.resultSet.updateInt(n2, n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.resultSet.updateLong(n2, l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.resultSet.updateFloat(n2, f2);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.resultSet.updateDouble(n2, d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(n2, bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.resultSet.updateString(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.resultSet.updateDate(n2, date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.resultSet.updateTime(n2, time);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.resultSet.updateObject(n2, object);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.resultSet.updateObject(n2, object, n3);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.resultSet.updateNull(string);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(string, bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.resultSet.updateByte(string, by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.resultSet.updateShort(string, s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.resultSet.updateInt(string, n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.resultSet.updateLong(string, l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.resultSet.updateFloat(string, f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.resultSet.updateDouble(string, d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(string, bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.resultSet.updateString(string, string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(string, byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.resultSet.updateDate(string, date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.resultSet.updateTime(string, time);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.resultSet.updateObject(string, object);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.resultSet.updateObject(string, object, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream, n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream, n2);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(string, timestamp);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader, n2);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        return ((OracleResultSet)this.resultSet).getURL(n2);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return ((OracleResultSet)this.resultSet).getURL(string);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        ((OracleResultSet)this.resultSet).updateRef(n2, ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        ((OracleResultSet)this.resultSet).updateRef(string, ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateBlob(n2, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateBlob(string, blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateClob(n2, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        ((OracleResultSet)this.resultSet).updateClob(string, clob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        ((OracleResultSet)this.resultSet).updateArray(n2, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        ((OracleResultSet)this.resultSet).updateArray(string, array);
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection != null) {
            this.connection.commit();
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.connection != null) {
            this.connection.rollback(savepoint);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        }
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        if (this.connection != null) {
            ((OracleConnection)this.connection).oracleRollback(oracleSavepoint);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.connection != null) {
            return this.connection.getAutoCommit();
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        return true;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.connection != null) {
            this.connection.setAutoCommit(bl);
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 302);
        }
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    String getTableName() throws SQLException {
        return this.getMetaData().getTableName(this.getMatchColumnIndexes()[0]);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.resultSet.getNCharacterStream(n2);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        return this.resultSet.getNClob(n2);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.resultSet.getNClob(string);
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.resultSet.getNString(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.resultSet.getRowId(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        return this.resultSet.getSQLXML(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.resultSet.getNCharacterStream(string);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.resultSet.getNString(string);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.resultSet.getRowId(string);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.resultSet.getSQLXML(string);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.preparedStatement.setAsciiStream(n2, inputStream);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBinaryStream(n2, inputStream);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBlob(n2, inputStream);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.preparedStatement.setBlob(n2, inputStream, l2);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.preparedStatement.setNCharacterStream(n2, reader);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.preparedStatement.setNCharacterStream(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        this.preparedStatement.setNClob(n2, nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        this.preparedStatement.setNClob(n2, reader);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.preparedStatement.setNClob(n2, reader);
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        this.preparedStatement.setNString(n2, string);
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        this.preparedStatement.setRowId(n2, rowId);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.preparedStatement.setSQLXML(n2, sQLXML);
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        this.preparedStatement.setURL(n2, uRL);
    }

    public void setArray(String string, Array array) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setArrayAtName(string, array);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBigDecimalAtName(string, bigDecimal);
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBlobAtName(string, blob);
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBooleanAtName(string, bl);
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setByteAtName(string, by);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBytesAtName(string, byArray);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setClobAtName(string, clob);
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setDateAtName(string, date);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setDateAtName(string, date, calendar);
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setDoubleAtName(string, d2);
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setFloatAtName(string, f2);
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setIntAtName(string, n2);
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setLongAtName(string, l2);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNClobAtName(string, nClob);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNStringAtName(string, string2);
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setObjectAtName(string, object);
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setObjectAtName(string, object, n2);
    }

    public void setRef(String string, Ref ref) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setRefAtName(string, ref);
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setRowIdAtName(string, rowId);
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setShortAtName(string, s2);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setSQLXMLAtName(string, sQLXML);
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setStringAtName(string, string2);
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setTimeAtName(string, time);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setTimeAtName(string, time, calendar);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setTimestampAtName(string, timestamp);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setTimestampAtName(string, timestamp, calendar);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setURLAtName(string, uRL);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBlobAtName(string, inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBlobAtName(string, inputStream, l2);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setClobAtName(string, reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setClobAtName(string, reader, l2);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNClobAtName(string, reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNClobAtName(string, reader, l2);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setAsciiStreamAtName(string, inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setAsciiStreamAtName(string, inputStream, n2);
    }

    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setAsciiStreamAtName(string, inputStream, l2);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBinaryStreamAtName(string, inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBinaryStreamAtName(string, inputStream, n2);
    }

    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setBinaryStreamAtName(string, inputStream, l2);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setCharacterStreamAtName(string, reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setCharacterStreamAtName(string, reader, n2);
    }

    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setCharacterStreamAtName(string, reader, l2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNCharacterStreamAtName(string, reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNCharacterStreamAtName(string, reader, l2);
    }

    public void setUnicodeStream(String string, InputStream inputStream, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setUnicodeStreamAtName(string, inputStream, n2);
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNullAtName(string, n2);
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setNullAtName(string, n2, string2);
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        ((OraclePreparedStatement)this.preparedStatement).setObjectAtName(string, object, n2, n3);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.resultSet.updateAsciiStream(n2, inputStream);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.resultSet.updateAsciiStream(n2, inputStream, l2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.resultSet.updateBinaryStream(n2, inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.resultSet.updateBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream, l2);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.resultSet.updateBlob(n2, inputStream);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.resultSet.updateBlob(n2, inputStream, l2);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.resultSet.updateBlob(string, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.resultSet.updateBlob(string, inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.resultSet.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.resultSet.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader, l2);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.resultSet.updateClob(n2, reader);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.resultSet.updateClob(n2, reader, l2);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.resultSet.updateClob(string, reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        this.resultSet.updateClob(string, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.resultSet.updateNCharacterStream(n2, reader);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.resultSet.updateNCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.resultSet.updateNCharacterStream(string, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.resultSet.updateNCharacterStream(string, reader, l2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.resultSet.updateNClob(n2, nClob);
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        this.resultSet.updateNClob(n2, reader);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        this.resultSet.updateNClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.resultSet.updateNClob(string, nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.resultSet.updateNClob(string, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        this.resultSet.updateNClob(string, reader, l2);
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.resultSet.updateNString(n2, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.resultSet.updateNString(string, string2);
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        this.resultSet.updateRowId(n2, rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.resultSet.updateRowId(string, rowId);
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.resultSet.updateSQLXML(n2, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.resultSet.updateSQLXML(string, sQLXML);
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return (oracle.jdbc.internal.OracleConnection)this.connection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

