/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;
import p.rn.util.FileWalker;

public class AsmVerify
extends BaseCmd {
    @BaseCmd.Opt(opt="d", longOpt="detail", hasArg=false, description="Print detail error message")
    boolean detail = false;

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        return n == -1 ? name : "o";
    }

    public static void main(String[] args) {
        new AsmVerify().doMain(args);
    }

    static void printAnalyzerResult(MethodNode method, Analyzer a, PrintWriter pw) throws IllegalArgumentException {
        int j;
        Frame[] frames = a.getFrames();
        XTraceMethodVisitor mv = new XTraceMethodVisitor();
        String format = "%05d %-" + (method.maxStack + method.maxLocals + 6) + "s|%s";
        for (j = 0; j < method.instructions.size(); ++j) {
            method.instructions.get(j).accept((MethodVisitor)mv);
            StringBuffer s = new StringBuffer();
            Frame f = frames[j];
            if (f == null) {
                s.append('?');
            } else {
                int k;
                for (k = 0; k < f.getLocals(); ++k) {
                    s.append(AsmVerify.getShortName(f.getLocal(k).toString()));
                }
                s.append(" : ");
                for (k = 0; k < f.getStackSize(); ++k) {
                    s.append(AsmVerify.getShortName(f.getStack(k).toString()));
                }
            }
            pw.printf(format, j, s, mv.getBuf());
        }
        for (j = 0; j < method.tryCatchBlocks.size(); ++j) {
            ((TryCatchBlockNode)method.tryCatchBlocks.get(j)).accept((MethodVisitor)mv);
            pw.print(" " + mv.getBuf());
        }
        pw.println();
        pw.flush();
    }

    public AsmVerify() {
        super("d2j-asm-verify [options] <jar0> [jar1 ... jarN]", "Verify .class in jar");
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            this.usage();
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fn : this.remainingArgs) {
            File file = new File(fn);
            if (!file.exists()) {
                System.err.println(fn + " is not exists");
                this.usage();
                return;
            }
            files.add(file);
        }
        for (File file : files) {
            System.out.println("verify " + file);
            new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

                public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                    if (isDir || !name.endsWith(".class")) {
                        return;
                    }
                    InputStream is = current.get();
                    ClassReader cr = new ClassReader(is);
                    ClassNode cn = new ClassNode();
                    cr.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)cn, false), 2);
                    List methods = cn.methods;
                    for (int i = 0; i < methods.size(); ++i) {
                        MethodNode method = (MethodNode)methods.get(i);
                        BasicVerifier verifier = new BasicVerifier();
                        Analyzer a = new Analyzer((Interpreter)verifier);
                        try {
                            a.analyze(cn.name, method);
                            continue;
                        }
                        catch (Exception ex) {
                            System.err.println("Error verify method " + cr.getClassName() + "." + method.name + " " + method.desc);
                            if (!AsmVerify.this.detail) continue;
                            ex.printStackTrace(System.err);
                            AsmVerify.printAnalyzerResult(method, a, new PrintWriter(System.err));
                        }
                    }
                }
            }).walk(file);
        }
    }

    static class XTraceMethodVisitor
    extends TraceMethodVisitor {
        XTraceMethodVisitor() {
        }

        public StringBuffer getBuf() {
            return this.buf;
        }
    }
}

