/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

public class Jar2Dex
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .dex file, default is $current_dir/[jar-name]-jar2dex.dex", argName="out-dex-file")
    private File output;

    public static void main(String[] args) {
        new Jar2Dex().doMain(args);
    }

    public Jar2Dex() {
        super("d2j-jar2dex [options] <dir>", "Convert jar to dex by invoking dx.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommandLine() throws Exception {
        File realJar;
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File jar = new File(this.remainingArgs[0]);
        if (!jar.exists()) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = jar.isDirectory() ? new File(jar.getName() + "-jar2dex.dex") : new File(FilenameUtils.getBaseName((String)jar.getName()) + "-jar2dex.dex");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        if (jar.isDirectory()) {
            realJar = File.createTempFile("d2j", ".jar");
            realJar.deleteOnExit();
            System.out.println("zipping " + jar + " -> " + realJar);
            FileOut.OutHandler out = FileOut.create((File)realJar, (boolean)true);
            try {
                new FileWalker().withStreamHandler((FileWalker.StreamHandler)new FileWalker.OutAdapter(out)).walk(jar);
            }
            finally {
                IOUtils.closeQuietly((Closeable)out);
            }
        } else {
            realJar = jar;
        }
        System.out.println("jar2dex " + realJar + " -> " + this.output);
        Class<?> c = Class.forName("com.android.dx.command.Main");
        Method m = c.getMethod("main", String[].class);
        ArrayList<String> ps = new ArrayList<String>();
        ps.addAll(Arrays.asList("--dex", "--no-strict", "--output=" + this.output.getCanonicalPath(), realJar.getCanonicalPath()));
        System.out.println("call com.android.dx.command.Main.main" + ps);
        m.invoke(null, new Object[]{ps.toArray(new String[0])});
    }
}

