/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.util.Duo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResPackage {
    private final ResTable mResTable;
    private final int mId;
    private final String mName;
    private final Map<ResID, ResResSpec> mResSpecs = new LinkedHashMap<ResID, ResResSpec>();
    private final Map<ResConfigFlags, ResConfig> mConfigs = new LinkedHashMap<ResConfigFlags, ResConfig>();
    private final Map<String, ResType> mTypes = new LinkedHashMap<String, ResType>();
    private final Set<ResID> mSynthesizedRes = new HashSet<ResID>();
    private ResValueFactory mValueFactory;

    public ResPackage(ResTable resTable, int id, String name) {
        this.mResTable = resTable;
        this.mId = id;
        this.mName = name;
    }

    public List<ResResSpec> listResSpecs() {
        return new ArrayList<ResResSpec>(this.mResSpecs.values());
    }

    public boolean hasResSpec(ResID resID) {
        return this.mResSpecs.containsKey(resID);
    }

    public ResResSpec getResSpec(ResID resID) throws UndefinedResObject {
        ResResSpec spec = this.mResSpecs.get(resID);
        if (spec == null) {
            throw new UndefinedResObject("resource spec: " + resID.toString());
        }
        return spec;
    }

    public List<ResConfig> getConfigs() {
        return new ArrayList<ResConfig>(this.mConfigs.values());
    }

    public boolean hasConfig(ResConfigFlags flags) {
        return this.mConfigs.containsKey(flags);
    }

    public ResConfig getConfig(ResConfigFlags flags) throws AndrolibException {
        ResConfig config = this.mConfigs.get(flags);
        if (config == null) {
            throw new UndefinedResObject("config: " + flags);
        }
        return config;
    }

    public ResConfig getOrCreateConfig(ResConfigFlags flags) throws AndrolibException {
        ResConfig config = this.mConfigs.get(flags);
        if (config == null) {
            config = new ResConfig(flags);
            this.mConfigs.put(flags, config);
        }
        return config;
    }

    public List<ResType> listTypes() {
        return new ArrayList<ResType>(this.mTypes.values());
    }

    public boolean hasType(String typeName) {
        return this.mTypes.containsKey(typeName);
    }

    public ResType getType(String typeName) throws AndrolibException {
        ResType type = this.mTypes.get(typeName);
        if (type == null) {
            throw new UndefinedResObject("type: " + typeName);
        }
        return type;
    }

    public Set<ResResource> listFiles() {
        HashSet<ResResource> ret = new HashSet<ResResource>();
        for (ResResSpec spec : this.mResSpecs.values()) {
            for (ResResource res : spec.listResources()) {
                if (!(res.getValue() instanceof ResFileValue)) continue;
                ret.add(res);
            }
        }
        return ret;
    }

    public Collection<ResValuesFile> listValuesFiles() {
        HashMap<Duo<ResType, ResConfig>, ResValuesFile> ret = new HashMap<Duo<ResType, ResConfig>, ResValuesFile>();
        for (ResResSpec spec : this.mResSpecs.values()) {
            for (ResResource res : spec.listResources()) {
                ResConfig config;
                if (!(res.getValue() instanceof ResValuesXmlSerializable)) continue;
                ResType type = res.getResSpec().getType();
                Duo<ResType, ResConfig> key = new Duo<ResType, ResConfig>(type, config = res.getConfig());
                ResValuesFile values = (ResValuesFile)ret.get(key);
                if (values == null) {
                    values = new ResValuesFile(this, type, config);
                    ret.put(key, values);
                }
                values.addResource(res);
            }
        }
        return ret.values();
    }

    public ResTable getResTable() {
        return this.mResTable;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    boolean isSynthesized(ResID resId) {
        return this.mSynthesizedRes.contains(resId);
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getId(), spec) != null) {
            throw new AndrolibException("Multiple resource specs: " + spec);
        }
    }

    public void addConfig(ResConfig config) throws AndrolibException {
        if (this.mConfigs.put(config.getFlags(), config) != null) {
            throw new AndrolibException("Multiple configs: " + config);
        }
    }

    public void addType(ResType type) throws AndrolibException {
        if (this.mTypes.put(type.getName(), type) != null) {
            throw new AndrolibException("Multiple types: " + type);
        }
    }

    public void addResource(ResResource res) {
    }

    public void addSynthesizedRes(int resId) {
        this.mSynthesizedRes.add(new ResID(resId));
    }

    public String toString() {
        return this.mName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResPackage other = (ResPackage)obj;
        if (!(this.mResTable == other.mResTable || this.mResTable != null && this.mResTable.equals(other.mResTable))) {
            return false;
        }
        return this.mId == other.mId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.mResTable != null ? this.mResTable.hashCode() : 0);
        hash = 37 * hash + this.mId;
        return hash;
    }

    public ResValueFactory getValueFactory() {
        if (this.mValueFactory == null) {
            this.mValueFactory = new ResValueFactory(this);
        }
        return this.mValueFactory;
    }
}

