/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.util.Duo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TypeName {
    public final String package_;
    public final String type;
    public final String innerType;
    public final int array;
    private Boolean mIsFileOwner;

    public TypeName(String type, int array) {
        this(null, type, null, array);
    }

    public TypeName(String package_, String type, String innerType, int array) {
        this.package_ = package_;
        this.type = type;
        this.innerType = innerType;
        this.array = array;
    }

    public String getShortenedName() {
        return this.getName("java.lang".equals(this.package_), this.isFileOwner());
    }

    public String getName() {
        return this.getName(false, false);
    }

    public String getName(boolean excludePackage, boolean separateInner) {
        String name = (this.package_ == null || excludePackage ? "" : this.package_ + '.') + this.type + (this.innerType != null ? (separateInner ? (char)'$' : '.') + this.innerType : "");
        for (int i = 0; i < this.array; ++i) {
            name = name + "[]";
        }
        return name;
    }

    public String getJavaFilePath() {
        return this.getFilePath(this.isFileOwner()) + ".java";
    }

    public String getSmaliFilePath() {
        return this.getFilePath(true) + ".smali";
    }

    public String getFilePath(boolean separateInner) {
        return this.package_.replace('.', File.separatorChar) + File.separatorChar + this.type + (separateInner && this.isInner() ? "$" + this.innerType : "");
    }

    public boolean isInner() {
        return this.innerType != null;
    }

    public boolean isArray() {
        return this.array != 0;
    }

    public boolean isFileOwner() {
        if (this.mIsFileOwner == null) {
            char c;
            this.mIsFileOwner = true;
            if (this.isInner() && ((c = this.innerType.charAt(0)) < '0' || c > '9')) {
                this.mIsFileOwner = false;
            }
        }
        return this.mIsFileOwner;
    }

    public String toString() {
        return this.getName();
    }

    public static TypeName fromInternalName(String internal) throws AndrolibException {
        Duo<TypeName, Integer> duo = TypeName.fetchFromInternalName(internal);
        if (((Integer)duo.m2).intValue() != internal.length()) {
            throw new AndrolibException("Invalid internal name: " + internal);
        }
        return (TypeName)duo.m1;
    }

    public static List<TypeName> listFromInternalName(String internal) throws AndrolibException {
        ArrayList<TypeName> types = new ArrayList<TypeName>();
        while (!internal.isEmpty()) {
            Duo<TypeName, Integer> duo = TypeName.fetchFromInternalName(internal);
            types.add((TypeName)duo.m1);
            internal = internal.substring((Integer)duo.m2);
        }
        return types;
    }

    public static Duo<TypeName, Integer> fetchFromInternalName(String internal) throws AndrolibException {
        String origInternal = internal;
        int array = 0;
        boolean isArray = false;
        do {
            if (internal.isEmpty()) {
                throw new AndrolibException("Invalid internal name: " + origInternal);
            }
            boolean bl = isArray = internal.charAt(0) == '[';
            if (!isArray) continue;
            ++array;
            internal = internal.substring(1);
        } while (isArray);
        int length = array + 1;
        String package_ = null;
        String type = null;
        String innerType = null;
        switch (internal.charAt(0)) {
            case 'B': {
                type = "byte";
                break;
            }
            case 'C': {
                type = "char";
                break;
            }
            case 'D': {
                type = "double";
                break;
            }
            case 'F': {
                type = "float";
                break;
            }
            case 'I': {
                type = "int";
                break;
            }
            case 'J': {
                type = "long";
                break;
            }
            case 'S': {
                type = "short";
                break;
            }
            case 'Z': {
                type = "boolean";
                break;
            }
            case 'V': {
                type = "void";
                break;
            }
            case 'L': {
                int pos = internal.indexOf(59);
                if (pos == -1) {
                    throw new AndrolibException("Invalid internal name: " + origInternal);
                }
                length += pos;
                if ((pos = (internal = internal.substring(1, pos)).lastIndexOf(47)) == -1) {
                    package_ = "";
                    type = internal;
                } else {
                    package_ = internal.substring(0, pos).replace('/', '.');
                    type = internal.substring(pos + 1);
                }
                pos = type.indexOf(36);
                if (pos == -1) break;
                innerType = type.substring(pos + 1);
                type = type.substring(0, pos);
                break;
            }
            default: {
                throw new AndrolibException("Invalid internal name: " + origInternal);
            }
        }
        return new Duo<TypeName, Integer>(new TypeName(package_, type, innerType, array), length);
    }
}

