/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseSwitchMethodItem
extends InstructionMethodItem<SparseSwitchDataPseudoInstruction> {
    private final List<SparseSwitchTarget> targets;

    public SparseSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int codeAddress, SparseSwitchDataPseudoInstruction instruction) {
        super(codeItem, codeAddress, instruction);
        int baseCodeAddress = methodDefinition.getSparseSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<SparseSwitchTarget>();
        Iterator<SparseSwitchDataPseudoInstruction.SparseSwitchTarget> iterator = instruction.iterateKeysAndTargets();
        if (baseCodeAddress >= 0) {
            while (iterator.hasNext()) {
                SparseSwitchDataPseudoInstruction.SparseSwitchTarget target = iterator.next();
                SparseSwitchLabelTarget sparseSwitchLabelTarget = new SparseSwitchLabelTarget();
                sparseSwitchLabelTarget.Key = target.key;
                LabelMethodItem label = new LabelMethodItem(baseCodeAddress + target.targetAddressOffset, "sswitch_");
                sparseSwitchLabelTarget.Target = label = methodDefinition.getLabelCache().internLabel(label);
                this.targets.add(sparseSwitchLabelTarget);
            }
        } else {
            while (iterator.hasNext()) {
                SparseSwitchDataPseudoInstruction.SparseSwitchTarget target = iterator.next();
                SparseSwitchOffsetTarget sparseSwitchOffsetTarget = new SparseSwitchOffsetTarget();
                sparseSwitchOffsetTarget.Key = target.key;
                sparseSwitchOffsetTarget.Target = target.targetAddressOffset;
                this.targets.add(sparseSwitchOffsetTarget);
            }
        }
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".sparse-switch\n");
        writer.indent(4);
        for (SparseSwitchTarget target : this.targets) {
            IntegerRenderer.writeTo(writer, target.Key);
            writer.write(" -> ");
            target.writeTargetTo(writer);
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end sparse-switch");
        return true;
    }

    private static class SparseSwitchOffsetTarget
    extends SparseSwitchTarget {
        public int Target;

        private SparseSwitchOffsetTarget() {
        }

        public void writeTargetTo(IndentingWriter writer) throws IOException {
            if (this.Target >= 0) {
                writer.write(43);
            }
            writer.printSignedIntAsDec(this.Target);
        }
    }

    private static class SparseSwitchLabelTarget
    extends SparseSwitchTarget {
        public LabelMethodItem Target;

        private SparseSwitchLabelTarget() {
        }

        public void writeTargetTo(IndentingWriter writer) throws IOException {
            this.Target.writeTo(writer);
        }
    }

    private static abstract class SparseSwitchTarget {
        public int Key;

        private SparseSwitchTarget() {
        }

        public abstract void writeTargetTo(IndentingWriter var1) throws IOException;
    }
}

