/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Collections;
import java.util.List;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDirectoryItem
extends Item<AnnotationDirectoryItem> {
    private AnnotationSetItem classAnnotations;
    private FieldIdItem[] fieldAnnotationFields;
    private AnnotationSetItem[] fieldAnnotations;
    private MethodIdItem[] methodAnnotationMethods;
    private AnnotationSetItem[] methodAnnotations;
    private MethodIdItem[] parameterAnnotationMethods;
    private AnnotationSetRefList[] parameterAnnotations;
    private ClassDefItem parent = null;

    protected AnnotationDirectoryItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationDirectoryItem(DexFile dexFile, AnnotationSetItem classAnnotations, FieldIdItem[] fieldAnnotationFields, AnnotationSetItem[] fieldAnnotations, MethodIdItem[] methodAnnotationMethods, AnnotationSetItem[] methodAnnotations, MethodIdItem[] parameterAnnotationMethods, AnnotationSetRefList[] parameterAnnotations) {
        super(dexFile);
        this.classAnnotations = classAnnotations;
        this.fieldAnnotationFields = fieldAnnotationFields;
        this.fieldAnnotations = fieldAnnotations;
        this.methodAnnotationMethods = methodAnnotationMethods;
        this.methodAnnotations = methodAnnotations;
        this.parameterAnnotationMethods = parameterAnnotationMethods;
        this.parameterAnnotations = parameterAnnotations;
    }

    public static AnnotationDirectoryItem internAnnotationDirectoryItem(DexFile dexFile, AnnotationSetItem classAnnotations, List<FieldAnnotation> fieldAnnotations, List<MethodAnnotation> methodAnnotations, List<ParameterAnnotation> parameterAnnotations) {
        int index;
        FieldIdItem[] fieldAnnotationFields = null;
        AnnotationSetItem[] fieldAnnotationsArray = null;
        MethodIdItem[] methodAnnotationMethods = null;
        AnnotationSetItem[] methodAnnotationsArray = null;
        MethodIdItem[] parameterAnnotationMethods = null;
        AnnotationSetRefList[] parameterAnnotationsArray = null;
        if (fieldAnnotations != null && fieldAnnotations.size() > 0) {
            fieldAnnotationFields = new FieldIdItem[fieldAnnotations.size()];
            fieldAnnotationsArray = new AnnotationSetItem[fieldAnnotations.size()];
            Collections.sort(fieldAnnotations);
            index = 0;
            for (FieldAnnotation fieldAnnotation : fieldAnnotations) {
                fieldAnnotationFields[index] = fieldAnnotation.field;
                fieldAnnotationsArray[index++] = fieldAnnotation.annotationSet;
            }
        }
        if (methodAnnotations != null && methodAnnotations.size() > 0) {
            methodAnnotationMethods = new MethodIdItem[methodAnnotations.size()];
            methodAnnotationsArray = new AnnotationSetItem[methodAnnotations.size()];
            Collections.sort(methodAnnotations);
            index = 0;
            for (MethodAnnotation methodAnnotation : methodAnnotations) {
                methodAnnotationMethods[index] = methodAnnotation.method;
                methodAnnotationsArray[index++] = methodAnnotation.annotationSet;
            }
        }
        if (parameterAnnotations != null && parameterAnnotations.size() > 0) {
            parameterAnnotationMethods = new MethodIdItem[parameterAnnotations.size()];
            parameterAnnotationsArray = new AnnotationSetRefList[parameterAnnotations.size()];
            Collections.sort(parameterAnnotations);
            index = 0;
            for (ParameterAnnotation parameterAnnotation : parameterAnnotations) {
                parameterAnnotationMethods[index] = parameterAnnotation.method;
                parameterAnnotationsArray[index++] = parameterAnnotation.annotationSet;
            }
        }
        AnnotationDirectoryItem annotationDirectoryItem = new AnnotationDirectoryItem(dexFile, classAnnotations, fieldAnnotationFields, fieldAnnotationsArray, methodAnnotationMethods, methodAnnotationsArray, parameterAnnotationMethods, parameterAnnotationsArray);
        return dexFile.AnnotationDirectoriesSection.intern(annotationDirectoryItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        int i;
        this.classAnnotations = (AnnotationSetItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
        this.fieldAnnotationFields = new FieldIdItem[in.readInt()];
        this.fieldAnnotations = new AnnotationSetItem[this.fieldAnnotationFields.length];
        this.methodAnnotationMethods = new MethodIdItem[in.readInt()];
        this.methodAnnotations = new AnnotationSetItem[this.methodAnnotationMethods.length];
        this.parameterAnnotationMethods = new MethodIdItem[in.readInt()];
        this.parameterAnnotations = new AnnotationSetRefList[this.parameterAnnotationMethods.length];
        for (i = 0; i < this.fieldAnnotations.length; ++i) {
            try {
                this.fieldAnnotationFields[i] = this.dexFile.FieldIdsSection.getItemByIndex(in.readInt());
                this.fieldAnnotations[i] = (AnnotationSetItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error occured while reading FieldAnnotation at index " + i);
            }
        }
        for (i = 0; i < this.methodAnnotations.length; ++i) {
            try {
                this.methodAnnotationMethods[i] = this.dexFile.MethodIdsSection.getItemByIndex(in.readInt());
                this.methodAnnotations[i] = (AnnotationSetItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error occured while reading MethodAnnotation at index " + i);
            }
        }
        for (i = 0; i < this.parameterAnnotations.length; ++i) {
            try {
                this.parameterAnnotationMethods[i] = this.dexFile.MethodIdsSection.getItemByIndex(in.readInt());
                this.parameterAnnotations[i] = (AnnotationSetRefList)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_REF_LIST, in.readInt());
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error occured while reading ParameterAnnotation at index " + i);
            }
        }
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 16 + ((this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length) + (this.methodAnnotations == null ? 0 : this.methodAnnotations.length) + (this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length)) * 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        int i;
        if (out.annotates()) {
            int i2;
            int index;
            if (!this.isInternable() && this.parent != null) {
                out.annotate(0, this.parent.getClassType().getTypeDescriptor());
            }
            if (this.classAnnotations != null) {
                out.annotate(4, "class_annotations_off: 0x" + Integer.toHexString(this.classAnnotations.getOffset()));
            } else {
                out.annotate(4, "class_annotations_off:");
            }
            int length = this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length;
            out.annotate(4, "annotated_fields_size: 0x" + Integer.toHexString(length) + " (" + length + ")");
            length = this.methodAnnotations == null ? 0 : this.methodAnnotations.length;
            out.annotate(4, "annotated_methods_size: 0x" + Integer.toHexString(length) + " (" + length + ")");
            length = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
            out.annotate(4, "annotated_parameters_size: 0x" + Integer.toHexString(length) + " (" + length + ")");
            if (this.fieldAnnotations != null) {
                index = 0;
                for (i2 = 0; i2 < this.fieldAnnotations.length; ++i2) {
                    out.annotate(0, "[" + index++ + "] field_annotation");
                    out.indent();
                    out.annotate(4, "field: " + this.fieldAnnotationFields[i2].getFieldName().getStringValue() + ":" + this.fieldAnnotationFields[i2].getFieldType().getTypeDescriptor());
                    out.annotate(4, "annotations_off: 0x" + Integer.toHexString(this.fieldAnnotations[i2].getOffset()));
                    out.deindent();
                }
            }
            if (this.methodAnnotations != null) {
                index = 0;
                for (i2 = 0; i2 < this.methodAnnotations.length; ++i2) {
                    out.annotate(0, "[" + index++ + "] method_annotation");
                    out.indent();
                    out.annotate(4, "method: " + this.methodAnnotationMethods[i2].getMethodString());
                    out.annotate(4, "annotations_off: 0x" + Integer.toHexString(this.methodAnnotations[i2].getOffset()));
                    out.deindent();
                }
            }
            if (this.parameterAnnotations != null) {
                index = 0;
                for (i2 = 0; i2 < this.parameterAnnotations.length; ++i2) {
                    out.annotate(0, "[" + index++ + "] parameter_annotation");
                    out.indent();
                    out.annotate(4, "method: " + this.parameterAnnotationMethods[i2].getMethodString());
                    out.annotate(4, "annotations_off: 0x" + Integer.toHexString(this.parameterAnnotations[i2].getOffset()));
                }
            }
        }
        out.writeInt(this.classAnnotations == null ? 0 : this.classAnnotations.getOffset());
        out.writeInt(this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length);
        out.writeInt(this.methodAnnotations == null ? 0 : this.methodAnnotations.length);
        out.writeInt(this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length);
        if (this.fieldAnnotations != null) {
            for (i = 0; i < this.fieldAnnotations.length; ++i) {
                out.writeInt(this.fieldAnnotationFields[i].getIndex());
                out.writeInt(this.fieldAnnotations[i].getOffset());
            }
        }
        if (this.methodAnnotations != null) {
            for (i = 0; i < this.methodAnnotations.length; ++i) {
                out.writeInt(this.methodAnnotationMethods[i].getIndex());
                out.writeInt(this.methodAnnotations[i].getOffset());
            }
        }
        if (this.parameterAnnotations != null) {
            for (i = 0; i < this.parameterAnnotations.length; ++i) {
                out.writeInt(this.parameterAnnotationMethods[i].getIndex());
                out.writeInt(this.parameterAnnotations[i].getOffset());
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        if (this.parent == null) {
            return "annotation_directory_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "annotation_directory_item @0x" + Integer.toHexString(this.getOffset()) + " (" + this.parent.getClassType() + ")";
    }

    @Override
    public int compareTo(AnnotationDirectoryItem o) {
        if (!this.isInternable()) {
            if (!o.isInternable()) {
                return this.parent.compareTo(o.parent);
            }
            return -1;
        }
        if (!o.isInternable()) {
            return 1;
        }
        return this.classAnnotations.compareTo(o.classAnnotations);
    }

    public AnnotationSetItem getClassAnnotations() {
        return this.classAnnotations;
    }

    public void iterateFieldAnnotations(FieldAnnotationIteratorDelegate delegate) {
        for (int i = 0; i < this.fieldAnnotationFields.length; ++i) {
            try {
                delegate.processFieldAnnotations(this.fieldAnnotationFields[i], this.fieldAnnotations[i]);
                continue;
            }
            catch (Exception ex) {
                throw this.addExceptionContext(ExceptionWithContext.withContext(ex, "Error occured while processing field annotations for field: " + this.fieldAnnotationFields[i].getFieldString()));
            }
        }
    }

    public int getFieldAnnotationCount() {
        return this.fieldAnnotationFields.length;
    }

    public void iterateMethodAnnotations(MethodAnnotationIteratorDelegate delegate) {
        for (int i = 0; i < this.methodAnnotationMethods.length; ++i) {
            try {
                delegate.processMethodAnnotations(this.methodAnnotationMethods[i], this.methodAnnotations[i]);
                continue;
            }
            catch (Exception ex) {
                throw this.addExceptionContext(ExceptionWithContext.withContext(ex, "Error occured while processing method annotations for method: " + this.methodAnnotationMethods[i].getMethodString()));
            }
        }
    }

    public int getMethodAnnotationCount() {
        return this.methodAnnotationMethods.length;
    }

    public void iterateParameterAnnotations(ParameterAnnotationIteratorDelegate delegate) {
        for (int i = 0; i < this.parameterAnnotationMethods.length; ++i) {
            try {
                delegate.processParameterAnnotations(this.parameterAnnotationMethods[i], this.parameterAnnotations[i]);
                continue;
            }
            catch (Exception ex) {
                throw this.addExceptionContext(ExceptionWithContext.withContext(ex, "Error occured while processing parameter annotations for method: " + this.parameterAnnotationMethods[i].getMethodString()));
            }
        }
    }

    public int getParameterAnnotationCount() {
        return this.parameterAnnotationMethods.length;
    }

    private boolean isInternable() {
        return !(this.classAnnotations == null || this.fieldAnnotations != null && this.fieldAnnotations.length != 0 || this.methodAnnotations != null && this.methodAnnotations.length != 0 || this.parameterAnnotations != null && this.parameterAnnotations.length != 0);
    }

    protected void setParent(ClassDefItem classDefItem) {
        this.parent = classDefItem;
    }

    public int hashCode() {
        if (!this.isInternable()) {
            return super.hashCode();
        }
        return this.classAnnotations.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AnnotationDirectoryItem other = (AnnotationDirectoryItem)o;
        return this.compareTo(other) == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterAnnotation
    implements Comparable<ParameterAnnotation> {
        public final MethodIdItem method;
        public final AnnotationSetRefList annotationSet;

        public ParameterAnnotation(MethodIdItem method, AnnotationSetRefList annotationSet) {
            this.method = method;
            this.annotationSet = annotationSet;
        }

        @Override
        public int compareTo(ParameterAnnotation other) {
            return this.method.compareTo(other.method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodAnnotation
    implements Comparable<MethodAnnotation> {
        public final MethodIdItem method;
        public final AnnotationSetItem annotationSet;

        public MethodAnnotation(MethodIdItem method, AnnotationSetItem annotationSet) {
            this.method = method;
            this.annotationSet = annotationSet;
        }

        @Override
        public int compareTo(MethodAnnotation other) {
            return this.method.compareTo(other.method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldAnnotation
    implements Comparable<FieldAnnotation> {
        public final FieldIdItem field;
        public final AnnotationSetItem annotationSet;

        public FieldAnnotation(FieldIdItem field, AnnotationSetItem annotationSet) {
            this.field = field;
            this.annotationSet = annotationSet;
        }

        @Override
        public int compareTo(FieldAnnotation other) {
            return this.field.compareTo(other.field);
        }
    }

    public static interface ParameterAnnotationIteratorDelegate {
        public void processParameterAnnotations(MethodIdItem var1, AnnotationSetRefList var2);
    }

    public static interface MethodAnnotationIteratorDelegate {
        public void processMethodAnnotations(MethodIdItem var1, AnnotationSetItem var2);
    }

    public static interface FieldAnnotationIteratorDelegate {
        public void processFieldAnnotations(FieldIdItem var1, AnnotationSetItem var2);
    }
}

