/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldIdItem
extends Item<FieldIdItem> {
    private int hashCode = 0;
    private TypeIdItem classType;
    private TypeIdItem fieldType;
    private StringIdItem fieldName;
    String cachedFieldString = null;

    protected FieldIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private FieldIdItem(DexFile dexFile, TypeIdItem classType, TypeIdItem fieldType, StringIdItem fieldName) {
        this(dexFile);
        assert (classType.dexFile == dexFile);
        assert (fieldType.dexFile == dexFile);
        assert (fieldName.dexFile == dexFile);
        this.classType = classType;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
    }

    public static FieldIdItem internFieldIdItem(DexFile dexFile, TypeIdItem classType, TypeIdItem fieldType, StringIdItem fieldName) {
        FieldIdItem fieldIdItem = new FieldIdItem(dexFile, classType, fieldType, fieldName);
        return dexFile.FieldIdsSection.intern(fieldIdItem);
    }

    public static FieldIdItem lookupFieldIdItem(DexFile dexFile, TypeIdItem classType, TypeIdItem fieldType, StringIdItem fieldName) {
        FieldIdItem fieldIdItem = new FieldIdItem(dexFile, classType, fieldType, fieldName);
        return dexFile.FieldIdsSection.getInternedItem(fieldIdItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.classType = this.dexFile.TypeIdsSection.getItemByIndex(in.readShort());
        this.fieldType = this.dexFile.TypeIdsSection.getItemByIndex(in.readShort());
        this.fieldName = this.dexFile.StringIdsSection.getItemByIndex(in.readInt());
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        int classIndex;
        if (out.annotates()) {
            out.annotate(2, "class_type: " + this.classType.getTypeDescriptor());
            out.annotate(2, "field_type: " + this.fieldType.getTypeDescriptor());
            out.annotate(4, "field_name: " + this.fieldName.getStringValue());
        }
        if ((classIndex = this.classType.getIndex()) > 65535) {
            throw new RuntimeException(String.format("Error writing field_id_item for %s. The type index of defining class %s is too large", this.getFieldString(), this.classType.getTypeDescriptor()));
        }
        out.writeShort(classIndex);
        int typeIndex = this.fieldType.getIndex();
        if (typeIndex > 65535) {
            throw new RuntimeException(String.format("Error writing field_id_item for %s. The type index of field type %s is too large", this.getFieldString(), this.fieldType.getTypeDescriptor()));
        }
        out.writeShort(typeIndex);
        out.writeInt(this.fieldName.getIndex());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_FIELD_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return this.getFieldString();
    }

    @Override
    public int compareTo(FieldIdItem o) {
        int result = this.classType.compareTo(o.classType);
        if (result != 0) {
            return result;
        }
        result = this.fieldName.compareTo(o.fieldName);
        if (result != 0) {
            return result;
        }
        return this.fieldType.compareTo(o.fieldType);
    }

    public TypeIdItem getContainingClass() {
        return this.classType;
    }

    public TypeIdItem getFieldType() {
        return this.fieldType;
    }

    public StringIdItem getFieldName() {
        return this.fieldName;
    }

    public String getFieldString() {
        if (this.cachedFieldString == null) {
            String typeDescriptor = this.classType.getTypeDescriptor();
            String fieldName = this.fieldName.getStringValue();
            String fieldType = this.fieldType.getTypeDescriptor();
            StringBuffer sb = new StringBuffer(typeDescriptor.length() + fieldName.length() + fieldType.length() + 3);
            sb.append(typeDescriptor);
            sb.append("->");
            sb.append(fieldName);
            sb.append(":");
            sb.append(fieldType);
            this.cachedFieldString = sb.toString();
        }
        return this.cachedFieldString;
    }

    private void calcHashCode() {
        this.hashCode = this.classType.hashCode();
        this.hashCode = 31 * this.hashCode + this.fieldType.hashCode();
        this.hashCode = 31 * this.hashCode + this.fieldName.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        FieldIdItem other = (FieldIdItem)o;
        return this.classType == other.classType && this.fieldType == other.fieldType && this.fieldName == other.fieldName;
    }
}

