/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResPluralsValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private final ResStringValue[] mItems = new ResStringValue[6];
    private static final String[] QUANTITY_MAP = new String[]{"other", "zero", "one", "two", "few", "many"};

    ResPluralsValue(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items) {
        super(parent);
        for (int i = 0; i < items.length; ++i) {
            this.mItems[((Integer)items[i].m1).intValue() - 0x1000004] = (ResStringValue)items[i].m2;
        }
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        serializer.startTag(null, "plurals");
        serializer.attribute(null, "name", res.getResSpec().getName());
        for (int i = 0; i < this.mItems.length; ++i) {
            ResStringValue item = this.mItems[i];
            if (item == null) continue;
            serializer.startTag(null, "item");
            serializer.attribute(null, "quantity", QUANTITY_MAP[i]);
            serializer.text(item.encodeAsResXmlValue());
            serializer.endTag(null, "item");
        }
        serializer.endTag(null, "plurals");
    }
}

