/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction31c
extends InstructionWithReference
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;

    public Instruction31c(Opcode opcode, short regA, Item referencedItem) {
        super(opcode, referencedItem);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
    }

    private Instruction31c(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(dexFile, opcode, buffer, bufferIndex);
        this.regA = buffer[bufferIndex + 1];
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeInt(this.getReferencedItem().getIndex());
    }

    protected int getReferencedItemIndex(byte[] buffer, int bufferIndex) {
        return NumberUtils.decodeInt(buffer, bufferIndex + 2);
    }

    public Format getFormat() {
        return Format.Format31c;
    }

    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction31c(dexFile, opcode, buffer, bufferIndex);
        }
    }
}

