/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser;

import de.fau.cs.osr.ptk.common.ParserCommon;
import java.io.IOException;
import java.io.StringReader;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WtEntityMapImpl;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.parser.RatsWikitextParser;
import org.sweble.wikitext.parser.preprocessor.PreprocessedWikitext;
import xtc.parser.ParseError;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.parser.SemanticValue;

public class WikitextParser
extends ParserCommon<WtNode> {
    private final ParserConfig config;
    private RatsWikitextParser parser;

    public WikitextParser(ParserConfig config) {
        this.config = config;
    }

    public Object getConfig() {
        return this.config;
    }

    public WtNode parseArticle(String src, String title) throws IOException, ParseException {
        PreprocessedWikitext ppWt = new PreprocessedWikitext(src, new WtEntityMapImpl());
        return this.parseArticle(ppWt, title);
    }

    public WtNode parseArticle(PreprocessedWikitext wikitext, String title) throws IOException, ParseException {
        StringReader in = new StringReader(wikitext.getWikitext());
        int inputSize = wikitext.getWikitext().getBytes().length;
        this.parser = new RatsWikitextParser(in, title, inputSize);
        this.parser.getState().init(this.config, wikitext.getEntityMap());
        this.parser.setNodeFactory(this.config.getNodeFactory());
        Result r = null;
        r = this.parser.pArticle(0);
        if (RatsWikitextParser.isStatsEnabled()) {
            RatsWikitextParser.getStats().dump(System.err);
        }
        if (r.hasValue()) {
            SemanticValue v = (SemanticValue)r;
            if (v.value instanceof WtParsedWikitextPage) {
                return (WtNode)this.process((WtParsedWikitextPage)v.value);
            }
            throw new ParseException("Internal parser error: Unexpected parser result type!");
        }
        ParseError err = (ParseError)r;
        if (err.index == -1) {
            throw new ParseException("Parse error: No information available");
        }
        throw new ParseException(String.format("%s: %s", this.parser.location(err.index), err.msg));
    }
}

