/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.parser;

public final class LinkTargetException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final Reason reason;
    private String offendingSubstring;

    public LinkTargetException(Reason reason, String title) {
        super(LinkTargetException.makeMessage(reason, title, null));
        this.reason = reason;
        this.title = title;
    }

    public LinkTargetException(Reason reason, String title, String offendingSubstring) {
        super(LinkTargetException.makeMessage(reason, title, offendingSubstring));
        this.reason = reason;
        this.title = title;
        this.offendingSubstring = offendingSubstring;
    }

    public String getTitle() {
        return this.title;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getOffendingSubstring() {
        return this.offendingSubstring;
    }

    private static String makeMessage(Reason reason, String title, String offendingSubstring) {
        return String.format(reason.getDescription(), title, offendingSubstring);
    }

    public static enum Reason {
        EMPTY_TARGET("Target string must not be empty (or contain only characters that are reduced to whitespace)"),
        INVALID_ENTITIES("The title `%1$s' contains invalid entities: %2$s"),
        ONLY_NAMESPACE("A namespace alone is not a valid link target: %1$s"),
        NO_ARTICLE_TITLE("Title part of target string is empty: %1$s"),
        IW_IW_LINK("An interwiki name cannot be followed by another interwiki name `%2$s' in target `%1$s'"),
        TALK_NS_IW_LINK("The Talk namespace in a link target may not be followed by another namespace or interwiki name `%2$s' in target `%1$s'");

        private String description;

        private Reason(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

