/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sweble.wikitext.parser.NonStandardElementBehavior;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WikitextWarning;
import org.sweble.wikitext.parser.nodes.WikitextNodeFactory;
import org.sweble.wikitext.parser.nodes.WikitextNodeFactoryImpl;
import org.sweble.wikitext.parser.parser.LinkBuilder;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.parser.LinkTargetParser;
import org.sweble.wikitext.parser.utils.AstTextUtils;
import org.sweble.wikitext.parser.utils.AstTextUtilsImpl;

public class SimpleParserConfig
implements ParserConfig {
    private final boolean convertIllegalCodePoints;
    private final boolean warningsEnabled;
    private final boolean gatherRtd;
    private final boolean autoCorrect;
    private final boolean langConvTagsEnabled;
    private final WikitextNodeFactory nodeFactory;
    private final AstTextUtilsImpl textUtils;
    private static final Set<String> knownFlags = new HashSet<String>(Arrays.asList("A", "T", "R", "D", "-", "H", "N"));
    private static final Set<String> knownVariants = new HashSet<String>(Arrays.asList("zh", "zh-hans", "zh-hant", "zh-cn", "zh-tw", "zh-hk", "zh-sg"));

    public SimpleParserConfig() {
        this(false, true, true, false, true);
    }

    public SimpleParserConfig(boolean warningsEnabled, boolean gatherRtd, boolean autoCorrect) {
        this.convertIllegalCodePoints = false;
        this.warningsEnabled = warningsEnabled;
        this.gatherRtd = gatherRtd;
        this.autoCorrect = autoCorrect;
        this.langConvTagsEnabled = true;
        this.nodeFactory = new WikitextNodeFactoryImpl(this);
        this.textUtils = new AstTextUtilsImpl(this);
    }

    public SimpleParserConfig(boolean warningsEnabled, boolean gatherRtd, boolean autoCorrect, boolean langConvTagsEnabled) {
        this.convertIllegalCodePoints = false;
        this.warningsEnabled = warningsEnabled;
        this.gatherRtd = gatherRtd;
        this.autoCorrect = autoCorrect;
        this.langConvTagsEnabled = langConvTagsEnabled;
        this.nodeFactory = new WikitextNodeFactoryImpl(this);
        this.textUtils = new AstTextUtilsImpl(this);
    }

    public SimpleParserConfig(boolean convertIllegalCodePoints, boolean warningsEnabled, boolean gatherRtd, boolean autoCorrect, boolean langConvTagsEnabled) {
        this.convertIllegalCodePoints = convertIllegalCodePoints;
        this.warningsEnabled = warningsEnabled;
        this.gatherRtd = gatherRtd;
        this.autoCorrect = autoCorrect;
        this.langConvTagsEnabled = langConvTagsEnabled;
        this.nodeFactory = new WikitextNodeFactoryImpl(this);
        this.textUtils = new AstTextUtilsImpl(this);
    }

    @Override
    public boolean isConvertIllegalCodePoints() {
        return this.convertIllegalCodePoints;
    }

    @Override
    public boolean isWarningsEnabled() {
        return this.warningsEnabled;
    }

    @Override
    public boolean isWarningLevelEnabled(WikitextWarning.WarningSeverity severity) {
        return true;
    }

    @Override
    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    @Override
    public boolean isGatherRtData() {
        return this.gatherRtd;
    }

    @Override
    public WikitextNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public AstTextUtils getAstTextUtils() {
        return this.textUtils;
    }

    @Override
    public boolean isUrlProtocol(String proto) {
        return "http://".equalsIgnoreCase(proto) || "https://".equalsIgnoreCase(proto) || "mail:".equalsIgnoreCase(proto);
    }

    @Override
    public String getInternalLinkPrefixPattern() {
        return "[\u00e4\u00f6\u00fc\u00dfa-z]+";
    }

    @Override
    public String getInternalLinkPostfixPattern() {
        return "[\u00e4\u00f6\u00fc\u00dfa-z]+";
    }

    @Override
    public LinkBuilder.LinkType classifyTarget(String target) {
        LinkTargetParser ltp = new LinkTargetParser();
        try {
            ltp.parse(this, target);
        }
        catch (LinkTargetException e) {
            return LinkBuilder.LinkType.INVALID;
        }
        String ns = ltp.getNamespace();
        if ("file".equalsIgnoreCase(ns) || "image".equalsIgnoreCase(ns)) {
            return LinkBuilder.LinkType.IMAGE;
        }
        return LinkBuilder.LinkType.PAGE;
    }

    @Override
    public boolean isNamespace(String name) {
        return "image".equalsIgnoreCase(name) || "file".equalsIgnoreCase(name) || "template".equals(name) || "media".equals(name) || "category".equals(name);
    }

    @Override
    public boolean isTalkNamespace(String resultNs) {
        return resultNs.toLowerCase().equals("talk");
    }

    @Override
    public boolean isInterwikiName(String name) {
        return "mediawiki".equalsIgnoreCase(name);
    }

    @Override
    public boolean isIwPrefixOfThisWiki(String iwPrefix) {
        return false;
    }

    @Override
    public boolean isValidPageSwitchName(String word) {
        return "NOTOC".equalsIgnoreCase(word);
    }

    @Override
    public boolean isValidExtensionTagName(String name) {
        return "ref".equalsIgnoreCase(name) || "pre".equalsIgnoreCase(name) || "nowiki".equalsIgnoreCase(name) || "gallery".equalsIgnoreCase(name) || "includeonly".equalsIgnoreCase(name) || "noinclude".equalsIgnoreCase(name) || "onlyinclude".equalsIgnoreCase(name);
    }

    @Override
    public boolean isRedirectKeyword(String keyword) {
        return keyword.equalsIgnoreCase("#redirect");
    }

    @Override
    public boolean isValidXmlEntityRef(String name) {
        return true;
    }

    public String resolveXmlEntity(String name) {
        if ("amp".equalsIgnoreCase(name)) {
            return "&";
        }
        if ("lt".equalsIgnoreCase(name)) {
            return "<";
        }
        if ("gt".equalsIgnoreCase(name)) {
            return ">";
        }
        if ("nbsp".equalsIgnoreCase(name)) {
            return "\u00a0";
        }
        if ("middot".equalsIgnoreCase(name)) {
            return "\u00b7";
        }
        if ("mdash".equalsIgnoreCase(name)) {
            return "\u2014";
        }
        if ("ndash".equalsIgnoreCase(name)) {
            return "\u2013";
        }
        if ("equiv".equalsIgnoreCase(name)) {
            return "\u2261";
        }
        return null;
    }

    @Override
    public Map<String, String> getXmlEntities() {
        return Collections.emptyMap();
    }

    @Override
    public NonStandardElementBehavior getNonStandardElementBehavior(String elementName) {
        return NonStandardElementBehavior.UNSPECIFIED;
    }

    @Override
    public boolean isFosterParenting() {
        return true;
    }

    @Override
    public boolean isFosterParentingForTransclusions() {
        return true;
    }

    @Override
    public boolean isPreserveSemiPreLeadingSpace() {
        return false;
    }

    @Override
    public boolean isLangConvTagsEnabled() {
        return this.langConvTagsEnabled;
    }

    @Override
    public boolean isLctFlag(String flag) {
        flag = this.normalizeLctFlag(flag);
        return knownFlags.contains(flag);
    }

    @Override
    public String normalizeLctFlag(String flag) {
        return flag.trim().toUpperCase();
    }

    @Override
    public boolean isLctVariant(String variant) {
        variant = this.normalizeLctVariant(variant);
        return knownVariants.contains(variant);
    }

    @Override
    public String normalizeLctVariant(String variant) {
        return variant.trim().toLowerCase();
    }
}

