/*
 * Decompiled with CFR 0.152.
 */
package tdb2;

import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.ProgressMonitor;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.ProgressStreamRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tdb2.cmdline.CmdTDB;
import tdb2.cmdline.CmdTDBGraph;

public class tdbloader
extends CmdTDBGraph {
    private static final ArgDecl argNoStats = new ArgDecl(false, "nostats");
    private static final ArgDecl argStats = new ArgDecl(true, "stats");
    private boolean showProgress = true;
    private boolean generateStats = true;
    public static int DataTickPoint = 100000;
    public static long IndexTickPoint = 500000L;
    public static int superTick = 10;
    private static Logger LOG = LoggerFactory.getLogger((String)"TDB2");

    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
        super.add(argNoStats, "--nostats", "Switch off statistics gathering");
        super.add(argStats);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    @Override
    protected void exec() {
        List<String> urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if (super.contains(argStats)) {
            if (!this.hasValueOfTrue(argStats) && !this.hasValueOfFalse(argStats)) {
                throw new CmdException("Not a boolean value: " + this.getValue(argStats));
            }
            this.generateStats = super.hasValueOfTrue(argStats);
        }
        if (super.contains(argNoStats)) {
            this.generateStats = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        }
        if (this.graphName == null) {
            this.loadQuads(urls);
            return;
        }
        for (String url : urls) {
            Lang lang = RDFLanguages.filenameToLang((String)url);
            if (lang == null || !RDFLanguages.isQuads((Lang)lang)) continue;
            System.err.println("Warning: Quads format given - only the default graph is loaded into the graph for --graph");
            break;
        }
        this.loadOneGraph(urls);
    }

    private void loadOneGraph(List<String> urls) {
        Graph graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    private void loadQuads(List<String> urls) {
        TDBLoader.load(this.getDatasetGraph(), urls, this.showProgress, this.generateStats);
    }

    static class TDBLoader {
        TDBLoader() {
        }

        public static void load(DatasetGraph dsg, List<String> urls, boolean showProgress, boolean generateStats) {
            StreamRDF dest = StreamRDFLib.dataset((DatasetGraph)dsg);
            Txn.executeWrite((Transactional)dsg, () -> urls.forEach(x -> TDBLoader.loadOne(dest, x, showProgress)));
        }

        public static void load(Graph graph, List<String> urls, boolean showProgress) {
            StreamRDF dest = StreamRDFLib.graph((Graph)graph);
            graph.getTransactionHandler().execute(() -> urls.forEach(x -> TDBLoader.loadOne(dest, x, showProgress)));
        }

        private static void loadOne(StreamRDF dest, String x, boolean showProgress) {
            StreamRDF sink = dest;
            ProgressMonitor monitor = null;
            if (showProgress) {
                String basename = (String)FileOps.splitDirFile((String)x).get(1);
                monitor = ProgressMonitor.create((Logger)LOG, (String)basename, (long)DataTickPoint, (int)superTick);
                sink = new ProgressStreamRDF(sink, monitor);
            }
            if (monitor != null) {
                monitor.start();
            }
            sink.start();
            RDFDataMgr.parse((StreamRDF)sink, (String)x);
            sink.finish();
            if (monitor != null) {
                monitor.finish();
                monitor.finishMessage();
            }
        }
    }
}

