/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstLocation;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.NoSuchPropertyException;
import de.fau.cs.osr.utils.WrappedException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.util.Pair;

public abstract class AstNodeImpl<T extends AstNode<T>>
extends AbstractList<T>
implements AstNode<T> {
    private static final long serialVersionUID = 3333532331617925714L;
    private HashMap<String, Object> attributes;
    private AstLocation location;

    protected AstNodeImpl() {
    }

    protected AstNodeImpl(AstLocation location) {
        this.setNativeLocation(location);
    }

    protected AstNodeImpl(Location location) {
        this.setLocation(location);
    }

    @Override
    public int getNodeType() {
        return -1;
    }

    @Override
    public boolean isNodeType(int testType) {
        return this.getNodeType() == testType;
    }

    @Override
    public final String getNodeTypeName() {
        return this.getClass().getName();
    }

    @Override
    public String getNodeName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    @Override
    public final Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public void setAttributes(Map<String, Object> attrs) {
        this.attributes = new HashMap<String, Object>(attrs);
    }

    @Override
    public void clearAttributes() {
        this.attributes = null;
    }

    @Override
    public final boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    @Override
    public final Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes.put(name, value);
    }

    @Override
    public Object removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        Object value = this.attributes.remove(name);
        if (this.attributes.isEmpty()) {
            this.attributes = null;
        }
        return value;
    }

    @Override
    public final int getIntAttribute(String name) {
        if (this.attributes == null) {
            return 0;
        }
        return (Integer)this.attributes.get(name);
    }

    @Override
    public Integer setIntAttribute(String name, Integer value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return (Integer)this.attributes.put(name, value);
    }

    @Override
    public final boolean getBooleanAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        Object o = this.attributes.get(name);
        if (null == o) {
            return false;
        }
        return (Boolean)o;
    }

    @Override
    public boolean setBooleanAttribute(String name, boolean value) {
        Boolean o;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if ((o = (Boolean)this.attributes.put(name, value)) == null) {
            return false;
        }
        return o;
    }

    @Override
    public final String getStringAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    @Override
    public String setStringAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return (String)this.attributes.put(name, value);
    }

    @Override
    public final boolean hasProperties() {
        return this.getPropertyCount() > 0;
    }

    @Override
    public int getPropertyCount() {
        return 0;
    }

    @Override
    public Object getProperty(String name) {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            if (!i.getName().equals(name)) continue;
            return i.getValue();
        }
        throw new NoSuchPropertyException();
    }

    @Override
    public Object getProperty(String name, Object default_) {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            if (!i.getName().equals(name)) continue;
            return i.getValue();
        }
        return default_;
    }

    @Override
    public boolean hasProperty(String name) {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            if (!i.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object setProperty(String name, Object value) {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            if (!i.getName().equals(name)) continue;
            Object old = i.getValue();
            i.setValue(value);
            return old;
        }
        throw new NoSuchPropertyException();
    }

    @Override
    public AstNodePropertyIterator propertyIterator() {
        return new AstNodePropertyIterator(){

            @Override
            protected String getName(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            protected Object getValue(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            protected Object setValue(int index, Object value) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            protected int getPropertyCount() {
                return 0;
            }
        };
    }

    public final boolean hasLocation() {
        return this.location != null;
    }

    public final Location getLocation() {
        if (this.location == null) {
            return null;
        }
        return this.location.toXtcLocation();
    }

    public void setLocation(Location location) {
        this.setNativeLocation(new AstLocation(location));
    }

    public void setLocation(Locatable locatable) {
        if (locatable.hasLocation()) {
            this.setLocation(locatable.getLocation());
        }
    }

    @Override
    public final AstLocation getNativeLocation() {
        return this.location;
    }

    @Override
    public void setNativeLocation(AstLocation location) {
        this.location = location;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S extends T> S get(int index, Class<S> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Pair<? extends T> p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public String[] getChildNames() {
        return EMPTY_CHILD_NAMES;
    }

    @Override
    public void toString(Appendable out) throws IOException {
        out.append(this.getClass().getSimpleName());
        out.append('(');
        boolean first = true;
        for (AstNode node : this) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            node.toString(out);
        }
        out.append(')');
    }

    @Override
    public String toString() {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder();
            try {
                this.toString(buf);
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AstNodeImpl n = (AstNodeImpl)super.clone();
        if (n.attributes != null) {
            n.attributes = new HashMap<String, Object>(n.attributes);
        }
        return n;
    }

    @Override
    public AstNodeImpl<T> cloneWrapException() {
        try {
            return (AstNodeImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    public AstNodeImpl<T> deepClone() throws CloneNotSupportedException {
        AstNodeImpl n = (AstNodeImpl)this.clone();
        if (this.isList()) {
            n.clear();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                n.add(((AstNode)i.next()).deepClone());
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                n.set(i, this.get(i).deepClone());
            }
        }
        return n;
    }

    @Override
    public AstNodeImpl<T> deepCloneWrapException() {
        try {
            return this.deepClone();
        }
        catch (CloneNotSupportedException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AstNodeImpl other = (AstNodeImpl)obj;
        return AstNodeImpl.equalsNoTypeCheck(this, other);
    }

    public static <S extends AstNode<S>> boolean equalsNoTypeCheck(AstNode<S> a, AstNode<S> b) {
        if (a.getNativeLocation() == null ? b.getNativeLocation() != null : !a.getNativeLocation().equals(b.getNativeLocation())) {
            return false;
        }
        if (a.getAttributes() == null ? b.getAttributes() != null : !a.getAttributes().equals(b.getAttributes())) {
            return false;
        }
        AstNodePropertyIterator p1 = a.propertyIterator();
        AstNodePropertyIterator p2 = b.propertyIterator();
        while (p1.next() & p2.next()) {
            Object v1 = p1.getValue();
            Object v2 = p2.getValue();
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        Iterator i1 = a.iterator();
        Iterator i2 = b.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            AstNode n1 = (AstNode)i1.next();
            AstNode n2 = (AstNode)i2.next();
            if (!(n1 == null ? n2 != null : !n1.equals(n2))) continue;
            return false;
        }
        return i1.hasNext() == i2.hasNext();
    }
}

