/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodeList;
import de.fau.cs.osr.ptk.common.ast.AstText;
import de.fau.cs.osr.utils.StringTools;
import de.fau.cs.osr.utils.WrappedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class RtData
implements Serializable,
Cloneable {
    public static final String SEP = new String();
    public static final RtData SUPPRESS = new RtDataSuppressSingleton();
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_FIELD = new Object[0];
    private final Object[][] fields;

    protected RtData() {
        this.fields = new Object[0][];
    }

    public RtData(AstNode<?> node) {
        this(node.size() + 1);
    }

    public RtData(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("RtData must have a size of at least 1");
        }
        this.fields = new Object[size][];
        Arrays.fill((Object[])this.fields, EMPTY_FIELD);
    }

    public RtData(AstNode<?> node, Object ... glue) {
        this(node);
        this.set(glue);
    }

    public RtData(int size, Object ... glue) {
        this(size);
        this.set(glue);
    }

    public RtData(AstNode<?> node, String ... glue) {
        this(node);
        this.set(glue);
    }

    public RtData(int size, String ... glue) {
        this(size);
        this.set(glue);
    }

    protected RtData(RtData rtData) {
        Object[][] other = rtData.fields;
        this.fields = new Object[other.length][];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = other[i] == EMPTY_FIELD ? EMPTY_FIELD : (Object[])other[i].clone();
        }
    }

    public void set(Object ... glue) {
        int seps = 0;
        int from = 0;
        int to = 0;
        for (int field = 0; field < this.fields.length; ++field) {
            while (to < glue.length) {
                if (glue[to] == SEP) {
                    ++seps;
                    break;
                }
                ++to;
            }
            this.setFieldFromArraySection(field, glue, from, to);
            if (to < glue.length) {
                // empty if block
            }
            from = ++to;
        }
        if (seps >= this.fields.length) {
            throw new IndexOutOfBoundsException("The glue array has too many fields!");
        }
    }

    public void set(String ... glue) {
        int seps = 0;
        int from = 0;
        int to = 0;
        for (int field = 0; field < this.fields.length; ++field) {
            while (to < glue.length) {
                if (glue[to] == SEP) {
                    ++seps;
                    break;
                }
                ++to;
            }
            this.setFieldFromArraySection(field, glue, from, to);
            if (to < glue.length) {
                // empty if block
            }
            from = ++to;
        }
        if (seps >= this.fields.length) {
            throw new IndexOutOfBoundsException("The glue array has too many fields!");
        }
    }

    public void setField(int field, Object ... glue) {
        this.setFieldFromArraySection(field, glue, 0, glue.length);
    }

    public void setField(int field, String ... glue) {
        this.setFieldFromArraySection(field, glue, 0, glue.length);
    }

    public void setField(int field, String glue) {
        this.fields[field] = glue == null || glue.isEmpty() ? EMPTY_FIELD : new Object[]{glue};
    }

    private void setFieldFromArraySection(int field, Object[] glue, int from, int to) {
        if (from < 0 || to > glue.length) {
            throw new IndexOutOfBoundsException();
        }
        if (to <= from) {
            return;
        }
        ArrayList<Object> result = new ArrayList<Object>(glue.length);
        for (int i = from; i < to; ++i) {
            Object o = glue[i];
            if (o == null) continue;
            if (o instanceof Object[]) {
                for (Object o2 : (Object[])o) {
                    this.addObject(result, o2);
                }
                continue;
            }
            this.addObject(result, o);
        }
        this.fields[field] = result.isEmpty() ? EMPTY_FIELD : result.toArray();
    }

    protected void addObject(ArrayList<Object> result, Object o) {
        if (o instanceof Character) {
            RtData.rtAddString(result, String.valueOf((Character)o));
        } else if (o instanceof String) {
            RtData.rtAddString(result, o.toString());
        } else {
            this.addNodeOrObject(result, o);
        }
    }

    protected void addNodeOrObject(ArrayList<Object> result, Object o) {
        if (o instanceof AstNode) {
            AstNode node = (AstNode)o;
            if (node.getNodeType() == 2) {
                for (AstNode c : (AstNodeList)o) {
                    this.addNodeOrObject(result, c);
                }
            } else if (node.getNodeType() == 4097) {
                RtData.rtAddString(result, ((AstText)o).getContent());
            } else {
                result.add(o);
            }
        } else {
            result.add(o);
        }
    }

    protected static void rtAddString(ArrayList<Object> result, String text) {
        Object last;
        if (text.isEmpty()) {
            return;
        }
        int i = result.size() - 1;
        if (i >= 0 && (last = result.get(i)) instanceof String) {
            result.set(i, (String)last + text);
            return;
        }
        result.add(text);
    }

    private void setFieldFromArraySection(int field, String[] glue, int from, int to) {
        if (from < 0 || to > glue.length) {
            throw new IndexOutOfBoundsException();
        }
        if (to <= from) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i1 = from; i1 < to; ++i1) {
            String g = glue[i1];
            if (g == null) continue;
            sb.append(g);
        }
        this.setField(field, sb.toString());
    }

    public boolean isSuppress() {
        return this == SUPPRESS;
    }

    public int size() {
        return this.fields.length;
    }

    public Object[][] getFields() {
        return this.fields;
    }

    public Object[] getField(int index) {
        return this.fields[index];
    }

    public String toString(int index) {
        Object[] field = this.fields[index];
        if (field.length == 0) {
            return "";
        }
        if (field.length == 1 && field[0] instanceof String) {
            return (String)field[0];
        }
        StringBuilder sb = new StringBuilder();
        this.toString(index, sb);
        return sb.toString();
    }

    public boolean isStringOnly(int index) {
        Object[] field = this.fields[index];
        return field.length == 0 || field.length == 1 && field[0] instanceof String;
    }

    protected void toString(int index, StringBuilder sb) {
        Object[] field = this.fields[index];
        for (int i = 0; i < field.length; ++i) {
            Object o;
            if (i != 0) {
                sb.append(" + ");
            }
            if ((o = field[i]) instanceof String) {
                this.stringRep(sb, (String)o);
                continue;
            }
            this.stringRep(sb, o);
        }
    }

    protected void stringRep(StringBuilder sb, Object o) {
        sb.append(o.toString());
    }

    protected void stringRep(StringBuilder sb, String str) {
        sb.append('\"');
        sb.append(StringTools.escJava((String)str));
        sb.append('\"');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RTD[ ");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                sb.append(" <o> ");
            }
            if (this.getField(i).length == 0) {
                sb.append("\"\"");
                continue;
            }
            this.toString(i, sb);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public void prepend(Object ... glue) {
        if (glue.length == 0) {
            return;
        }
        this.setField(0, glue, this.getField(0));
    }

    public void append(Object ... glue) {
        if (glue.length == 0) {
            return;
        }
        int last = this.size() - 1;
        this.setField(last, this.getField(last), glue);
    }

    public void prepend(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Object[] firstField = this.fields[0];
        if (firstField.length == 0) {
            this.setField(0, text);
        } else {
            Object firstGlue = firstField[0];
            if (firstGlue instanceof String) {
                firstField[0] = text + firstGlue;
            } else {
                Object[] newField = new Object[firstField.length + 1];
                System.arraycopy(firstField, 0, newField, 1, firstField.length);
                newField[0] = text;
                this.fields[0] = newField;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.fields);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RtData other = (RtData)obj;
        return Arrays.deepEquals((Object[])this.fields, (Object[])other.fields);
    }

    public Object clone() throws CloneNotSupportedException {
        return new RtData(this);
    }

    public RtData cloneWrapException() {
        try {
            return (RtData)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    protected static class RtDataSuppressSingleton
    extends RtData {
        private static final long serialVersionUID = 1L;

        protected RtDataSuppressSingleton() {
        }

        @Override
        public void set(Object ... glue) {
            this.notSupported();
        }

        @Override
        public void set(String ... glue) {
            this.notSupported();
        }

        @Override
        public void setField(int field, Object ... glue) {
            this.notSupported();
        }

        @Override
        public void setField(int field, String glue) {
            this.notSupported();
        }

        @Override
        public void setField(int field, String ... glue) {
            this.notSupported();
        }

        @Override
        public void prepend(String text) {
            this.notSupported();
        }

        @Override
        public void append(Object ... glue) {
            this.notSupported();
        }

        @Override
        public void prepend(Object ... glue) {
            this.notSupported();
        }

        private void notSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }
}

