/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

public class DatamodelFilter {
    private final DataObjectFactory dataObjectFactory;
    private final DocumentDataFilter filter;

    public DatamodelFilter(DataObjectFactory dataObjectFactory, DocumentDataFilter filter) {
        this.dataObjectFactory = dataObjectFactory;
        this.filter = filter;
    }

    public ItemDocument filter(ItemDocument item) {
        return this.dataObjectFactory.getItemDocument(item.getEntityId(), this.filterMonoLingualTextValues(item.getLabels().values()), this.filterMonoLingualTextValues(item.getDescriptions().values()), this.filterMonoLingualTextValues(this.flatten(item.getAliases().values())), this.filterStatementGroups(item.getStatementGroups()), this.filterSiteLinks(item.getSiteLinks()), item.getRevisionId());
    }

    public PropertyDocument filter(PropertyDocument property) {
        return this.dataObjectFactory.getPropertyDocument(property.getEntityId(), this.filterMonoLingualTextValues(property.getLabels().values()), this.filterMonoLingualTextValues(property.getDescriptions().values()), this.filterMonoLingualTextValues(this.flatten(property.getAliases().values())), this.filterStatementGroups(property.getStatementGroups()), property.getDatatype(), property.getRevisionId());
    }

    public MediaInfoDocument filter(MediaInfoDocument mediaInfo) {
        return this.dataObjectFactory.getMediaInfoDocument(mediaInfo.getEntityId(), this.filterMonoLingualTextValues(mediaInfo.getLabels().values()), this.filterStatementGroups(mediaInfo.getStatementGroups()), mediaInfo.getRevisionId());
    }

    public LexemeDocument filter(LexemeDocument lexeme) {
        return this.dataObjectFactory.getLexemeDocument(lexeme.getEntityId(), lexeme.getLexicalCategory(), lexeme.getLanguage(), this.filterMonoLingualTextValues(lexeme.getLemmas().values()), this.filterStatementGroups(lexeme.getStatementGroups()), this.filterForms(lexeme.getForms()), this.filterSenses(lexeme.getSenses()), lexeme.getRevisionId());
    }

    public FormDocument filter(FormDocument form) {
        return this.dataObjectFactory.getFormDocument(form.getEntityId(), this.filterMonoLingualTextValues(form.getRepresentations().values()), form.getGrammaticalFeatures(), this.filterStatementGroups(form.getStatementGroups()), form.getRevisionId());
    }

    public SenseDocument filter(SenseDocument sense) {
        return this.dataObjectFactory.getSenseDocument(sense.getEntityId(), this.filterMonoLingualTextValues(sense.getGlosses().values()), this.filterStatementGroups(sense.getStatementGroups()), sense.getRevisionId());
    }

    private List<FormDocument> filterForms(List<FormDocument> forms) {
        ArrayList<FormDocument> filtered = new ArrayList<FormDocument>(forms.size());
        for (FormDocument form : forms) {
            filtered.add(this.filter(form));
        }
        return filtered;
    }

    private List<SenseDocument> filterSenses(List<SenseDocument> senses) {
        ArrayList<SenseDocument> filtered = new ArrayList<SenseDocument>(senses.size());
        for (SenseDocument sense : senses) {
            filtered.add(this.filter(sense));
        }
        return filtered;
    }

    private <T> List<T> flatten(Collection<List<T>> values) {
        ArrayList flattened = new ArrayList();
        for (Collection collection : values) {
            flattened.addAll(collection);
        }
        return flattened;
    }

    private List<MonolingualTextValue> filterMonoLingualTextValues(Collection<MonolingualTextValue> values) {
        if (this.filter.getLanguageFilter() == null) {
            return new ArrayList<MonolingualTextValue>(values);
        }
        if (this.filter.getLanguageFilter().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MonolingualTextValue> output = new ArrayList<MonolingualTextValue>();
        for (MonolingualTextValue value : values) {
            if (!this.filter.getLanguageFilter().contains(value.getLanguageCode())) continue;
            output.add(value);
        }
        return output;
    }

    private List<StatementGroup> filterStatementGroups(List<StatementGroup> statementGroups) {
        if (this.filter.getPropertyFilter() == null) {
            return statementGroups;
        }
        if (this.filter.getPropertyFilter().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StatementGroup> output = new ArrayList<StatementGroup>(statementGroups.size());
        for (StatementGroup statementGroup : statementGroups) {
            if (!this.filter.getPropertyFilter().contains(statementGroup.getProperty())) continue;
            output.add(statementGroup);
        }
        return output;
    }

    private Map<String, SiteLink> filterSiteLinks(Map<String, SiteLink> siteLinks) {
        if (this.filter.getSiteLinkFilter() == null) {
            return siteLinks;
        }
        if (this.filter.getSiteLinkFilter().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, SiteLink> result = new HashMap<String, SiteLink>(siteLinks.size());
        for (Map.Entry<String, SiteLink> entry : siteLinks.entrySet()) {
            if (!this.filter.getSiteLinkFilter().contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

