/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.wikidata.wdtk.datamodel.helpers.AbstractDataObjectBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;

public abstract class EntityDocumentBuilder<T extends EntityDocumentBuilder<T, O>, O extends TermedStatementDocument>
extends AbstractDataObjectBuilder<T, O> {
    EntityIdValue entityIdValue;
    final ArrayList<MonolingualTextValue> labels = new ArrayList();
    final ArrayList<MonolingualTextValue> descriptions = new ArrayList();
    final ArrayList<MonolingualTextValue> aliases = new ArrayList();
    final HashMap<PropertyIdValue, ArrayList<Statement>> statements = new HashMap();
    long revisionId = 0L;

    protected EntityDocumentBuilder(EntityIdValue entityIdValue) {
        this.entityIdValue = entityIdValue;
    }

    protected EntityDocumentBuilder(O initialDocument) {
        this.entityIdValue = initialDocument.getEntityId();
        this.revisionId = initialDocument.getRevisionId();
        for (MonolingualTextValue monolingualTextValue : initialDocument.getLabels().values()) {
            this.withLabel(monolingualTextValue);
        }
        for (MonolingualTextValue monolingualTextValue : initialDocument.getDescriptions().values()) {
            this.withDescription(monolingualTextValue);
        }
        for (List list : initialDocument.getAliases().values()) {
            for (MonolingualTextValue alias : list) {
                this.withAlias(alias);
            }
        }
        Iterator<Statement> iterator = initialDocument.getAllStatements();
        while (iterator.hasNext()) {
            this.withStatement(iterator.next());
        }
    }

    public T withRevisionId(long revisionId) {
        this.revisionId = revisionId;
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withEntityId(EntityIdValue entityId) {
        this.entityIdValue = entityId;
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withLabel(MonolingualTextValue mtv) {
        this.labels.add(mtv);
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withLabel(String text, String languageCode) {
        this.withLabel(factory.getMonolingualTextValue(text, languageCode));
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withDescription(MonolingualTextValue mtv) {
        this.descriptions.add(mtv);
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withDescription(String text, String languageCode) {
        this.withDescription(factory.getMonolingualTextValue(text, languageCode));
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withAlias(MonolingualTextValue mtv) {
        this.aliases.add(mtv);
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withAlias(String text, String languageCode) {
        this.withAlias(factory.getMonolingualTextValue(text, languageCode));
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    public T withStatement(Statement statement) {
        PropertyIdValue pid = statement.getMainSnak().getPropertyId();
        if (!this.statements.containsKey(pid)) {
            this.statements.put(pid, new ArrayList());
        }
        ArrayList<Statement> pidStatements = this.statements.get(pid);
        pidStatements.add(statement);
        return (T)((EntityDocumentBuilder)this.getThis());
    }

    protected List<StatementGroup> getStatementGroups() {
        ArrayList<StatementGroup> result = new ArrayList<StatementGroup>(this.statements.size());
        for (ArrayList<Statement> statementList : this.statements.values()) {
            result.add(factory.getStatementGroup(statementList));
        }
        return result;
    }
}

