/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.LexemeDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.MediaInfoDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;

public class JsonDeserializer {
    private ObjectReader entityDocumentReader;
    private ObjectReader itemReader;
    private ObjectReader propertyReader;
    private ObjectReader lexemeReader;
    private ObjectReader mediaInfoReader;

    public JsonDeserializer(String siteIri) {
        DatamodelMapper mapper = new DatamodelMapper(siteIri);
        this.entityDocumentReader = mapper.readerFor(EntityDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.itemReader = mapper.readerFor(ItemDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.propertyReader = mapper.readerFor(PropertyDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.lexemeReader = mapper.readerFor(LexemeDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        this.mediaInfoReader = mapper.readerFor(MediaInfoDocumentImpl.class).with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
    }

    public ItemDocument deserializeItemDocument(String json) throws IOException {
        return (ItemDocument)this.itemReader.readValue(json);
    }

    public PropertyDocument deserializePropertyDocument(String json) throws IOException {
        return (PropertyDocument)this.propertyReader.readValue(json);
    }

    public LexemeDocument deserializeLexemeDocument(String json) throws IOException {
        return (LexemeDocument)this.lexemeReader.readValue(json);
    }

    public MediaInfoDocument deserializeMediaInfoDocument(String json) throws IOException {
        return (MediaInfoDocument)this.mediaInfoReader.readValue(json);
    }

    public EntityDocument deserializeEntityDocument(String json) throws IOException {
        return (EntityDocument)this.entityDocumentReader.readValue(json);
    }
}

