/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wikidata.wdtk.datamodel.helpers.AbstractDataObjectBuilder;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Value;

public class ReferenceBuilder
extends AbstractDataObjectBuilder<ReferenceBuilder, Reference> {
    final HashMap<PropertyIdValue, ArrayList<Snak>> snaks = new HashMap();

    protected ReferenceBuilder() {
    }

    public static ReferenceBuilder newInstance() {
        return new ReferenceBuilder();
    }

    @Override
    public Reference build() {
        this.prepareBuild();
        return factory.getReference(this.getSnakGroups());
    }

    public ReferenceBuilder withPropertyValue(PropertyIdValue propertyIdValue, Value value) {
        this.getSnakList(propertyIdValue).add(factory.getValueSnak(propertyIdValue, value));
        return this.getThis();
    }

    public ReferenceBuilder withSomeValue(PropertyIdValue propertyIdValue) {
        this.getSnakList(propertyIdValue).add(factory.getSomeValueSnak(propertyIdValue));
        return this.getThis();
    }

    public ReferenceBuilder withNoValue(PropertyIdValue propertyIdValue) {
        this.getSnakList(propertyIdValue).add(factory.getNoValueSnak(propertyIdValue));
        return this.getThis();
    }

    @Override
    protected ReferenceBuilder getThis() {
        return this;
    }

    protected List<SnakGroup> getSnakGroups() {
        ArrayList<SnakGroup> result = new ArrayList<SnakGroup>(this.snaks.size());
        for (ArrayList<Snak> statementList : this.snaks.values()) {
            result.add(factory.getSnakGroup(statementList));
        }
        return result;
    }

    protected ArrayList<Snak> getSnakList(PropertyIdValue propertyIdValue) {
        if (!this.snaks.containsKey(propertyIdValue)) {
            this.snaks.put(propertyIdValue, new ArrayList());
        }
        return this.snaks.get(propertyIdValue);
    }
}

