/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.LabeledStatementDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.MediaInfoIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MediaInfoDocumentImpl
extends LabeledStatementDocumentImpl
implements MediaInfoDocument {
    public MediaInfoDocumentImpl(MediaInfoIdValue id, List<MonolingualTextValue> labels, List<StatementGroup> statements, long revisionId) {
        super((EntityIdValue)id, labels, statements, revisionId);
    }

    @JsonCreator
    public MediaInfoDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="labels") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> labels, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="statements") Map<String, List<StatementImpl.PreStatement>> statements, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, labels, statements == null ? claims : statements, revisionId, siteIri);
    }

    protected MediaInfoDocumentImpl(MediaInfoIdValue subject, Map<String, MonolingualTextValue> labels, Map<String, List<Statement>> claims, long revisionId) {
        super((EntityIdValue)subject, labels, claims, revisionId);
    }

    @Override
    @JsonIgnore
    public MediaInfoIdValue getEntityId() {
        return new MediaInfoIdValueImpl(this.entityId, this.siteIri);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsMediaInfoDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public MediaInfoDocument withRevisionId(long newRevisionId) {
        return new MediaInfoDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, List<Statement>>)this.claims, newRevisionId);
    }

    @Override
    public MediaInfoDocument withLabel(MonolingualTextValue newLabel) {
        return new MediaInfoDocumentImpl(this.getEntityId(), MediaInfoDocumentImpl.withTerm(this.labels, newLabel), (Map<String, List<Statement>>)this.claims, this.revisionId);
    }

    @Override
    public MediaInfoDocument withStatement(Statement statement) {
        Map<String, List<Statement>> newGroups = MediaInfoDocumentImpl.addStatementToGroups(statement, this.claims);
        return new MediaInfoDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, newGroups, this.revisionId);
    }

    @Override
    public MediaInfoDocument withoutStatementIds(Set<String> statementIds) {
        Map<String, List<Statement>> newGroups = MediaInfoDocumentImpl.removeStatements(statementIds, this.claims);
        return new MediaInfoDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, newGroups, this.revisionId);
    }
}

