/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SiteLinkImpl
implements SiteLink {
    private final String title;
    private final String site;
    private final List<ItemIdValue> badges;

    public SiteLinkImpl(String title, String site, List<ItemIdValue> badges) {
        Validate.notNull((Object)title);
        this.title = title;
        Validate.notNull((Object)site);
        this.site = site;
        this.badges = badges == null ? Collections.emptyList() : badges;
        this.badges.sort(Comparator.comparing(EntityIdValue::getId));
    }

    @JsonCreator
    SiteLinkImpl(@JsonProperty(value="title") String title, @JsonProperty(value="site") String site, @JsonProperty(value="badges") List<String> badges, @JacksonInject(value="siteIri") String siteIri) {
        Validate.notNull((Object)title);
        this.title = title;
        Validate.notNull((Object)site);
        this.site = site;
        this.badges = badges == null || badges.isEmpty() ? Collections.emptyList() : this.constructBadges(badges, siteIri);
    }

    private List<ItemIdValue> constructBadges(List<String> badges, String siteIri) {
        ArrayList<ItemIdValue> output = new ArrayList<ItemIdValue>(badges.size());
        for (String badge : badges) {
            output.add(new ItemIdValueImpl(badge, siteIri));
        }
        return output;
    }

    @Override
    @JsonProperty(value="title")
    public String getPageTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="site")
    public String getSiteKey() {
        return this.site;
    }

    @Override
    @JsonIgnore
    public List<ItemIdValue> getBadges() {
        return this.badges;
    }

    @JsonProperty(value="badges")
    List<String> getBadgesString() {
        if (this.badges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> output = new ArrayList<String>(this.badges.size());
        for (ItemIdValue badge : this.badges) {
            output.add(badge.getId());
        }
        return output;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsSiteLink(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

