/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;

public class SnakGroupImpl
extends AbstractList<Snak>
implements SnakGroup {
    private final List<Snak> snaks;

    public SnakGroupImpl(List<Snak> snaks) {
        if (snaks == null || snaks.isEmpty()) {
            throw new IllegalArgumentException("A non-empty list of Snaks must be provided to create a SnakGroup");
        }
        PropertyIdValue property = snaks.get(0).getPropertyId();
        for (Snak s : snaks) {
            if (property.equals(s.getPropertyId())) continue;
            throw new IllegalArgumentException("All snaks in a snak group must use the same property");
        }
        this.snaks = Collections.unmodifiableList(snaks);
    }

    @Override
    public Snak get(int i) {
        return this.snaks.get(i);
    }

    @Override
    public Iterator<Snak> iterator() {
        return this.snaks.iterator();
    }

    @Override
    public int size() {
        return this.snaks.size();
    }

    @Override
    public boolean isEmpty() {
        return this.snaks.isEmpty();
    }

    @Override
    public List<Snak> getSnaks() {
        return Collections.unmodifiableList(this.snaks);
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.snaks.get(0).getPropertyId();
    }

    public static List<SnakGroup> makeSnakGroups(Map<String, List<Snak>> snaks, List<String> propertyOrder) {
        ArrayList<SnakGroup> result = new ArrayList<SnakGroup>(snaks.size());
        for (String propertyName : propertyOrder) {
            result.add(new SnakGroupImpl(snaks.get(propertyName)));
        }
        return result;
    }

    @Override
    public int hashCode() {
        return Hash.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.equalsSnakGroup(this, obj);
    }

    @Override
    public String toString() {
        return ToString.toString(this);
    }
}

