/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.ValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.UnsupportedEntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonDeserialize
public class UnsupportedEntityIdValueImpl
extends ValueImpl
implements UnsupportedEntityIdValue {
    private final JacksonIdValue value;
    private final String siteIri;

    @JsonCreator
    private UnsupportedEntityIdValueImpl(@JsonProperty(value="value") JacksonIdValue value, @JacksonInject(value="siteIri") String siteIri) {
        super("wikibase-entityid");
        this.value = value;
        this.siteIri = siteIri;
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    @JsonIgnore
    public String getEntityType() {
        if (this.value.entityType == null) {
            return "http://www.wikidata.org/ontology#Unsupported";
        }
        Object[] parts = this.value.entityType.split("-");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.capitalize((String)parts[i]);
        }
        return "http://www.wikidata.org/ontology#" + StringUtils.join((Object[])parts);
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.value.getId();
    }

    @JsonProperty(value="value")
    protected JacksonIdValue getInnerValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public String getSiteIri() {
        return this.siteIri;
    }

    @Override
    @JsonIgnore
    public String getIri() {
        return this.siteIri.concat(this.value.getId());
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object other) {
        return Equality.equalsEntityIdValue(this, other);
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    @Override
    @JsonIgnore
    public String getEntityTypeJsonString() {
        return this.value.getEntityTypeString();
    }

    private static class JacksonIdValue {
        private final String entityType;
        private final String id;
        private final Map<String, JsonNode> contents;

        @JsonCreator
        private JacksonIdValue(@JsonProperty(value="entity-type") String entityType, @JsonProperty(value="id") String id) {
            Validate.notNull((Object)id);
            this.entityType = entityType;
            this.id = id;
            this.contents = new HashMap<String, JsonNode>();
        }

        @JsonProperty(value="entity-type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getEntityTypeString() {
            return this.entityType;
        }

        @JsonProperty(value="id")
        public String getId() {
            return this.id;
        }

        @JsonAnyGetter
        protected Map<String, JsonNode> getContents() {
            return this.contents;
        }

        @JsonAnySetter
        protected void loadContents(String key, JsonNode value) {
            this.contents.put(key, value);
        }
    }
}

