/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import com.ibm.icu.text.Normalizer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.ErrorHandler;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.Iso5426ToUnicode;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.Verifier;

public class MarcPermissiveStreamReader
implements MarcReader {
    private DataInputStream input = null;
    private Record record;
    private MarcFactory factory;
    private String encoding = "ISO8859_1";
    private String defaultEncoding = "ISO8859_1";
    private boolean convertToUTF8 = false;
    private boolean permissive = false;
    private CharConverter converterAnsel = null;
    private CharConverter converterUnimarc = null;
    private String conversionCheck1 = null;
    private String conversionCheck2 = null;
    private String conversionCheck3 = null;
    private ErrorHandler errors;
    static AnselToUnicode conv = null;
    static byte[] badEsc = new byte[]{98, 45, 27, 115};
    static byte[] overbar = new byte[]{-81};

    public MarcPermissiveStreamReader(InputStream input, boolean permissive, boolean convertToUTF8) {
        this.permissive = permissive;
        this.input = new DataInputStream(new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.errors = null;
        if (permissive) {
            this.errors = new ErrorHandler();
            this.defaultEncoding = "BESTGUESS";
        }
    }

    public MarcPermissiveStreamReader(InputStream input, ErrorHandler errors, boolean convertToUTF8) {
        if (errors != null) {
            this.permissive = true;
            this.defaultEncoding = "BESTGUESS";
        }
        this.input = new DataInputStream(new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.errors = errors;
    }

    public MarcPermissiveStreamReader(InputStream input, boolean permissive, boolean convertToUTF8, String defaultEncoding) {
        this.permissive = permissive;
        this.input = new DataInputStream(new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.defaultEncoding = defaultEncoding;
        this.errors = null;
        if (permissive) {
            this.errors = new ErrorHandler();
        }
    }

    public MarcPermissiveStreamReader(InputStream input, ErrorHandler errors, boolean convertToUTF8, String defaultEncoding) {
        this.permissive = true;
        this.input = new DataInputStream(new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.defaultEncoding = defaultEncoding;
        this.errors = errors;
    }

    public boolean hasNext() {
        try {
            return this.input.available() != 0;
        }
        catch (IOException e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public Record next() {
        this.record = this.factory.newRecord();
        if (this.errors != null) {
            this.errors.reset();
        }
        try {
            byte[] byteArray = new byte[24];
            this.input.readFully(byteArray);
            int recordLength = this.parseRecordLength(byteArray);
            byte[] recordBuf = new byte[recordLength - 24];
            if (this.permissive) {
                this.input.mark(recordLength * 2);
                this.input.readFully(recordBuf);
                if (recordBuf[recordBuf.length - 1] != 29) {
                    this.errors.addError("unknown", "n/a", "n/a", 3, "Record terminator character not found at end of record length");
                    recordBuf = this.rereadPermissively(this.input, recordBuf, recordLength);
                    recordLength = recordBuf.length + 24;
                }
            } else {
                this.input.readFully(recordBuf);
            }
            String tmp = new String(recordBuf);
            this.parseRecord(this.record, byteArray, recordBuf, recordLength);
            if (this.convertToUTF8) {
                Leader l = this.record.getLeader();
                l.setCharCodingScheme('a');
                this.record.setLeader(l);
            }
            return this.record;
        }
        catch (EOFException e) {
            throw new MarcException("Premature end of file encountered", e);
        }
        catch (IOException e) {
            throw new MarcException("an error occured reading input", e);
        }
    }

    private byte[] rereadPermissively(DataInputStream input, byte[] recordBuf, int recordLength) throws IOException {
        int loc = this.arrayContainsAt(recordBuf, 29);
        if (loc != -1) {
            this.errors.addError("unknown", "n/a", "n/a", 3, "Record terminator appears before stated record length, using shorter record");
            recordLength = loc + 24;
            input.reset();
            recordBuf = new byte[recordLength - 24];
            input.readFully(recordBuf);
        } else {
            loc = recordLength - 24;
            int c = 0;
            do {
                c = input.read();
            } while (++loc < recordLength + 100 && c != 29 && c != -1);
            if (c == 29) {
                this.errors.addError("unknown", "n/a", "n/a", 3, "Record terminator appears after stated record length, reading extra bytes");
                recordLength = loc + 24;
                input.reset();
                recordBuf = new byte[recordLength - 24];
                input.readFully(recordBuf);
            } else if (c == -1) {
                this.errors.addError("unknown", "n/a", "n/a", 3, "No Record terminator found, end of file reached, Terminator appended");
                recordLength = loc + 24;
                input.reset();
                recordBuf = new byte[recordLength - 24 + 1];
                input.readFully(recordBuf);
                recordBuf[recordBuf.length - 1] = 29;
            } else {
                this.errors.addError("unknown", "n/a", "n/a", 4, "No Record terminator found within 100 byts of stated location, giving up.");
            }
        }
        return recordBuf;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseRecord(Record record, byte[] byteArray, byte[] recordBuf, int recordLength) {
        block75: {
            block74: {
                ldr = this.factory.newLeader();
                ldr.setRecordLength(recordLength);
                directoryLength = 0;
                this.conversionCheck1 = "";
                this.conversionCheck2 = "";
                this.conversionCheck3 = "";
                try {
                    this.parseLeader(ldr, byteArray);
                    directoryLength = ldr.getBaseAddressOfData() - 25;
                    break block74;
                }
                catch (IOException e) {
                    throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
                }
                catch (MarcException e) {
                    if (!this.permissive) throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
                    if (recordBuf[recordBuf.length - 1] != 29 || recordBuf[recordBuf.length - 2] != 30) break block74;
                    this.errors.addError("unknown", "n/a", "n/a", 3, "Error parsing leader, trying to re-read leader either shorter or longer");
                    offset = 0;
                    ** while (offset < recordBuf.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (recordBuf[offset] == 30) break;
                    ++offset;
                    continue;
                }
lbl22:
                // 2 sources

                if (offset % 12 == 1) {
                    this.errors.addError("unknown", "n/a", "n/a", 3, "Leader appears to be too short, moving one byte from record body to leader, and trying again");
                    oldBody = recordBuf;
                    recordBuf = new byte[oldBody.length - 1];
                    System.arraycopy(oldBody, 1, recordBuf, 0, oldBody.length - 1);
                    directoryLength = offset - 1;
                    ldr.setIndicatorCount(2);
                    ldr.setSubfieldCodeLength(2);
                    ldr.setImplDefined1(((char)byteArray[7] + " ").toCharArray());
                    ldr.setImplDefined2(("" + (char)byteArray[18] + (char)byteArray[19] + (char)byteArray[20]).toCharArray());
                    ldr.setEntryMap("4500".toCharArray());
                    if (byteArray[10] == 32 || byteArray[10] == 97) {
                        ldr.setCharCodingScheme((char)byteArray[10]);
                    }
                } else if (offset % 12 == 11) {
                    this.errors.addError("unknown", "n/a", "n/a", 3, "Leader appears to be too long, moving one byte from leader to record body, and trying again");
                    oldBody = recordBuf;
                    recordBuf = new byte[oldBody.length + 1];
                    System.arraycopy(oldBody, 0, recordBuf, 1, oldBody.length);
                    recordBuf[0] = 48;
                    directoryLength = offset + 1;
                    ldr.setIndicatorCount(2);
                    ldr.setSubfieldCodeLength(2);
                    ldr.setImplDefined1(((char)byteArray[7] + " ").toCharArray());
                    ldr.setImplDefined2(("" + (char)byteArray[16] + (char)byteArray[17] + (char)byteArray[18]).toCharArray());
                    ldr.setEntryMap("4500".toCharArray());
                    if (byteArray[8] == 32 || byteArray[8] == 97) {
                        ldr.setCharCodingScheme((char)byteArray[10]);
                    }
                    if (byteArray[10] == 32 || byteArray[10] == 97) {
                        ldr.setCharCodingScheme((char)byteArray[10]);
                    }
                } else {
                    this.errors.addError("unknown", "n/a", "n/a", 4, "error parsing leader with data: " + new String(byteArray));
                    throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
                }
            }
            tmp = ldr.getEntryMap();
            if (this.permissive && !("" + tmp[0] + tmp[1] + tmp[2] + tmp[3]).equals("4500")) {
                if (tmp[0] >= '0' && tmp[0] <= '9' && tmp[1] >= '0' && tmp[1] <= '9' && tmp[2] >= '0' && tmp[2] <= '9' && tmp[3] >= '0' && tmp[3] <= '9') {
                    this.errors.addError("unknown", "n/a", "n/a", 1, "Unusual character found at end of leader [ " + tmp[0] + tmp[1] + tmp[2] + tmp[3] + " ]");
                } else {
                    this.errors.addError("unknown", "n/a", "n/a", 1, "Erroneous character found at end of leader [ " + tmp[0] + tmp[1] + tmp[2] + tmp[3] + " ]; changing them to the standard \"4500\"");
                    ldr.setEntryMap("4500".toCharArray());
                }
            }
            switch (ldr.getCharCodingScheme()) {
                case 'a': {
                    this.encoding = "UTF8";
                    break;
                }
                case ' ': {
                    if (this.convertToUTF8) {
                        this.encoding = this.defaultEncoding;
                        break;
                    }
                    this.encoding = "ISO8859_1";
                    break;
                }
                default: {
                    this.encoding = this.convertToUTF8 != false ? this.defaultEncoding : "ISO8859_1";
                }
            }
            if (this.encoding.equalsIgnoreCase("BESTGUESS")) {
                try {
                    marc8EscSeqCheck = new String(recordBuf, "ISO-8859-1");
                    if (marc8EscSeqCheck.split("\\e[-(,)$bsp]", 2).length > 1) {
                        this.encoding = "MARC8";
                        break block75;
                    }
                    hasHighBitChars = false;
                    i = 0;
                    while (i < recordBuf.length) {
                        if (recordBuf[i] < 0) {
                            hasHighBitChars = true;
                            break;
                        }
                        ++i;
                    }
                    if (!hasHighBitChars) {
                        this.encoding = "ISO8859_1";
                        break block75;
                    }
                    utfCheck = new String(recordBuf, "UTF-8");
                    byteCheck = utfCheck.getBytes("UTF-8");
                    this.encoding = "UTF8";
                    if (recordBuf.length == byteCheck.length) {
                        i = 0;
                        while (i < recordBuf.length) {
                            if (byteCheck[i] != recordBuf[i]) {
                                this.encoding = "MARC8-Maybe";
                                break block75;
                            }
                            ++i;
                        }
                        break block75;
                    }
                    this.encoding = "MARC8-Maybe";
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (this.permissive && this.encoding.equals("UTF8")) {
                try {
                    utfCheck = new String(recordBuf, "UTF-8");
                    byteCheck = utfCheck.getBytes("UTF-8");
                    if (recordBuf.length != byteCheck.length) {
                        foundESC = false;
                        i = 0;
                        while (i < recordBuf.length) {
                            if (recordBuf[i] == 27) {
                                this.errors.addError("unknown", "n/a", "n/a", 2, "Record claims to be UTF-8, but its not. Its probably MARC8.");
                                this.encoding = "MARC8-Maybe";
                                foundESC = true;
                                break;
                            }
                            if (byteCheck[i] != recordBuf[i]) {
                                this.encoding = "MARC8-Maybe";
                            }
                            ++i;
                        }
                        if (!foundESC) {
                            this.errors.addError("unknown", "n/a", "n/a", 2, "Record claims to be UTF-8, but its not. It may be MARC8, or maybe UNIMARC, or maybe raw ISO-8859-1 ");
                        }
                    }
                    if (utfCheck.contains("a$1!")) {
                        this.encoding = "MARC8-Broken";
                        this.errors.addError("unknown", "n/a", "n/a", 3, "Record claims to be UTF-8, but its not. It seems to be MARC8-encoded but with missing escape codes.");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (this.permissive && !this.encoding.equals("UTF8")) {
                try {
                    utfCheck = new String(recordBuf, "UTF-8");
                    byteCheck = utfCheck.getBytes("UTF-8");
                    if (recordBuf.length != byteCheck.length) break block75;
                    i = 0;
                    while (i < recordBuf.length) {
                        if (recordBuf[i] < 0 || byteCheck[i] != recordBuf[i]) {
                            this.errors.addError("unknown", "n/a", "n/a", 2, "Record claims not to be UTF-8, but it seems to be.");
                            this.encoding = "UTF8-Maybe";
                            break;
                        }
                        ++i;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        record.setLeader(ldr);
        discardOneAtStartOfDirectory = false;
        discardOneSomewhereInDirectory = false;
        if (directoryLength % 12 != 0) {
            if (this.permissive && directoryLength % 12 == 11 && recordBuf[1] != 48) {
                this.errors.addError("unknown", "n/a", "n/a", 3, "Directory length is not a multiple of 12 bytes long.  Prepending a zero and trying to continue.");
                oldBody = recordBuf;
                recordBuf = new byte[oldBody.length + 1];
                System.arraycopy(oldBody, 0, recordBuf, 1, oldBody.length);
                recordBuf[0] = 48;
                ++directoryLength;
            } else if (this.permissive && directoryLength % 12 == 1 && recordBuf[1] == 48 && recordBuf[2] == 48) {
                discardOneAtStartOfDirectory = true;
                this.errors.addError("unknown", "n/a", "n/a", 3, "Directory length is not a multiple of 12 bytes long. Discarding byte from start of directory and trying to continue.");
            } else if (this.permissive && directoryLength % 12 == 1 && recordLength > 10000 && recordBuf[0] == 48 && recordBuf[1] == 48 && recordBuf[2] > 48 && recordBuf[2] <= 57) {
                discardOneSomewhereInDirectory = true;
                this.errors.addError("unknown", "n/a", "n/a", 3, "Directory length is not a multiple of 12 bytes long.  Will look for oversized field and try to work around it.");
            } else {
                if (this.errors == null) throw new MarcException("Directory length is not a multiple of 12 bytes long. Unable to continue.");
                this.errors.addError("unknown", "n/a", "n/a", 4, "Directory length is not a multiple of 12 bytes long. Unable to continue.");
                throw new MarcException("Directory length is not a multiple of 12 bytes long. Unable to continue.");
            }
        }
        inputrec = new DataInputStream(new ByteArrayInputStream(recordBuf));
        size = directoryLength / 12;
        tags = new String[size];
        lengths = new int[size];
        tag = new byte[3];
        length = new byte[4];
        start = new byte[5];
        try {
            if (discardOneAtStartOfDirectory) {
                inputrec.read();
            }
            totalOffset = 0;
            i = 0;
            while (i < size) {
                inputrec.readFully(tag);
                tags[i] = tmpStr = new String(tag);
                proceedNormally = true;
                if (discardOneSomewhereInDirectory) {
                    lenCheck = new byte[10];
                    inputrec.mark(20);
                    inputrec.readFully(lenCheck);
                    if (this.byteCompare(lenCheck, 4, 5, totalOffset)) {
                        proceedNormally = true;
                    } else if (this.byteCompare(lenCheck, 5, 5, totalOffset)) {
                        discardOneSomewhereInDirectory = false;
                        this.errors.addError("unknown", "n/a", "n/a", 4, "Field is longer than 9999 bytes.  Writing this record out will result in a bad record.");
                        proceedNormally = false;
                    } else {
                        this.errors.addError("unknown", "n/a", "n/a", 4, "Unable to reconcile problems in directory. Unable to continue.");
                        throw new MarcException("Directory length is not a multiple of 12 bytes long. Unable to continue.");
                    }
                    inputrec.reset();
                }
                if (proceedNormally) {
                    inputrec.readFully(length);
                    tmpStr = new String(length);
                    lengths[i] = Integer.parseInt(tmpStr);
                    inputrec.readFully(start);
                } else {
                    inputrec.readFully(start);
                    tmpStr = new String(start);
                    lengths[i] = Integer.parseInt(tmpStr);
                    inputrec.readFully(start);
                }
                totalOffset += lengths[i];
                ++i;
            }
            if (discardOneSomewhereInDirectory) {
                inputrec.read();
            }
            if (inputrec.read() != 30) {
                this.errors.addError("unknown", "n/a", "n/a", 4, "Expected field terminator at end of directory. Unable to continue.");
                throw new MarcException("expected field terminator at end of directory");
            }
            numBadLengths = 0;
            totalLength = 0;
            i = 0;
            while (i < size) {
                fieldLength = this.getFieldLength(inputrec);
                if (fieldLength + 1 != lengths[i] && this.permissive && numBadLengths < 3 && totalLength + fieldLength < recordLength + 26) {
                    ++numBadLengths;
                    lengths[i] = fieldLength + 1;
                    this.errors.addError("unknown", "n/a", "n/a", 2, "Field length found in record different from length stated in the directory.");
                    if (fieldLength + 1 > 9999) {
                        this.errors.addError("unknown", "n/a", "n/a", 4, "Field length is greater than 9999, record cannot be represented as a binary Marc record.");
                    }
                }
                totalLength += lengths[i];
                if (this.isControlField(tags[i])) {
                    byteArray = new byte[lengths[i] - 1];
                    inputrec.readFully(byteArray);
                    if (inputrec.read() != 30) {
                        this.errors.addError("unknown", "n/a", "n/a", 4, "Expected field terminator at end of field. Unable to continue.");
                        throw new MarcException("expected field terminator at end of field");
                    }
                    field = this.factory.newControlField();
                    field.setTag(tags[i]);
                    field.setData(this.getDataAsString(byteArray));
                    record.addVariableField(field);
                } else {
                    byteArray = new byte[lengths[i]];
                    inputrec.readFully(byteArray);
                    try {
                        record.addVariableField(this.parseDataField(tags[i], byteArray));
                    }
                    catch (IOException e) {
                        throw new MarcException("error parsing data field for tag: " + tags[i] + " with data: " + new String(byteArray), e);
                    }
                }
                ++i;
            }
            if (this.permissive && this.conversionCheck1.length() > 1 && this.conversionCheck2.length() > 1 && this.conversionCheck3.length() > 1) {
                this.guessAndSelectCorrectNonUTF8Encoding();
            }
            if (inputrec.read() == 29) return;
            this.errors.addError("unknown", "n/a", "n/a", 4, "Expected record terminator at end of record. Unable to continue.");
            throw new MarcException("expected record terminator");
        }
        catch (IOException e) {
            this.errors.addError("unknown", "n/a", "n/a", 4, "Error reading from data file. Unable to continue.");
            throw new MarcException("an error occured reading input", e);
        }
    }

    private boolean byteCompare(byte[] lenCheck, int offset, int length, int totalOffset) {
        int divisor = 1;
        int i = offset + length - 1;
        while (i >= offset) {
            if (totalOffset / divisor % 10 + 48 != lenCheck[i]) {
                return false;
            }
            --i;
            divisor *= 10;
        }
        return true;
    }

    private boolean isControlField(String tag) {
        boolean isControl;
        block2: {
            isControl = false;
            try {
                isControl = Verifier.isControlField(tag);
            }
            catch (NumberFormatException nfe) {
                if (!this.permissive) break block2;
                this.errors.addError(this.record.getControlNumber(), tag, "n/a", 1, "Field tag contains non-numeric characters (" + tag + ").");
                isControl = false;
            }
        }
        return isControl;
    }

    private void guessAndSelectCorrectNonUTF8Encoding() {
        int defaultPart = 0;
        if (this.record.getVariableField("245") == null) {
            defaultPart = 1;
        }
        int partToUse = 0;
        int l1 = this.conversionCheck1.length();
        int l2 = this.conversionCheck2.length();
        int l3 = this.conversionCheck3.length();
        if (l1 < l3 && l2 == l3 && defaultPart == 0) {
            this.errors.addError(0, "MARC8 translation shorter than ISO-8859-1, choosing MARC8.");
            partToUse = 0;
        } else if (l2 < l1 - 2 && l2 < l3 - 2) {
            this.errors.addError(0, "Unimarc translation shortest, choosing it.");
            partToUse = 1;
        } else {
            int tst = this.onlyOneStartsWithUpperCase(this.conversionCheck1, this.conversionCheck2, this.conversionCheck3);
            if (tst != -1) {
                partToUse = tst;
            } else if (l2 < l1 && l2 < l3) {
                this.errors.addError(0, "Unimarc translation shortest, choosing it.");
                partToUse = 1;
            } else if (this.conversionCheck2.equals(this.conversionCheck3) && !this.conversionCheck1.trim().contains(" ")) {
                this.errors.addError(0, "Unimarc and ISO-8859-1 translations identical, choosing ISO-8859-1.");
                partToUse = 2;
            } else if (!this.specialCharIsBetweenLetters(this.conversionCheck1)) {
                this.errors.addError(0, "To few letters in translations, choosing " + (defaultPart == 0 ? "MARC8" : "Unimarc"));
                partToUse = defaultPart;
            } else if (l2 == l1 && l2 == l3) {
                this.errors.addError(0, "All three version equal length. Choosing ISO-8859-1 ");
                partToUse = 2;
            } else if (l2 == l3 && defaultPart == 1) {
                this.errors.addError(0, "Unimarc and ISO-8859-1 translations equal length, choosing ISO-8859-1.");
                partToUse = 2;
            } else {
                this.errors.addError(0, "No Determination made, defaulting to " + (defaultPart == 0 ? "MARC8" : "Unimarc"));
                partToUse = defaultPart;
            }
        }
        List fields = this.record.getVariableFields();
        for (VariableField field : fields) {
            if (!(field instanceof DataField)) continue;
            DataField df = (DataField)field;
            List subf = df.getSubfields();
            for (Subfield sf : subf) {
                if (!sf.getData().contains("%%@%%")) continue;
                String[] parts = sf.getData().split("%%@%%", 3);
                sf.setData(parts[partToUse]);
            }
        }
    }

    private int onlyOneStartsWithUpperCase(String conversionCheck12, String conversionCheck22, String conversionCheck32) {
        if (this.conversionCheck1.length() == 0 || this.conversionCheck2.length() == 0 || this.conversionCheck3.length() == 0) {
            return -1;
        }
        String[] check1Parts = this.conversionCheck1.trim().split("[|]>");
        String[] check2Parts = this.conversionCheck2.trim().split("[|]>");
        String[] check3Parts = this.conversionCheck3.trim().split("[|]>");
        int i = 1;
        while (i < check1Parts.length && i < check2Parts.length && i < check3Parts.length) {
            boolean tst1 = Character.isUpperCase(check1Parts[i].charAt(0));
            boolean tst2 = Character.isUpperCase(check2Parts[i].charAt(0));
            boolean tst3 = Character.isUpperCase(check3Parts[i].charAt(0));
            if (tst1 && !tst2 && !tst3) {
                return 0;
            }
            if (!tst1 && tst2 && !tst3) {
                return -1;
            }
            if (!tst1 && !tst2 && tst3) {
                return 2;
            }
            ++i;
        }
        return -1;
    }

    private boolean specialCharIsBetweenLetters(String conversionCheck) {
        boolean bewteenLetters = true;
        int i = 0;
        while (i < conversionCheck.length()) {
            char charCode = conversionCheck.charAt(i);
            if (charCode > '\u007f') {
                bewteenLetters = false;
                if (i > 0 && Character.isLetter((int)conversionCheck.charAt(i - 1)) || i < conversionCheck.length() - 1 && Character.isLetter((int)conversionCheck.charAt(i + 1))) {
                    bewteenLetters = true;
                    break;
                }
            }
            ++i;
        }
        return bewteenLetters;
    }

    private int arrayContainsAt(byte[] byteArray, int ft) {
        int i = 0;
        while (i < byteArray.length) {
            if (byteArray[i] == (byte)ft) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private DataField parseDataField(String tag, byte[] field) throws IOException {
        int readByte;
        if (this.permissive) {
            this.errors.setRecordID(this.record.getControlNumber());
            this.errors.setCurrentField(tag);
            this.errors.setCurrentSubfield("n/a");
            this.cleanupBadFieldSeperators(field);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(field);
        char ind1 = (char)bais.read();
        char ind2 = (char)bais.read();
        DataField dataField = this.factory.newDataField();
        dataField.setTag(tag);
        dataField.setIndicator1(ind1);
        dataField.setIndicator2(ind2);
        block3: while ((readByte = bais.read()) >= 0) {
            switch (readByte) {
                case 31: {
                    int code = bais.read();
                    if (code < 0) {
                        throw new IOException("unexpected end of data field");
                    }
                    if (code == 30) continue block3;
                    int size = this.getSubfieldLength(bais);
                    byte[] data = new byte[size];
                    bais.read(data);
                    Subfield subfield = this.factory.newSubfield();
                    if (this.permissive) {
                        this.errors.setCurrentSubfield("" + (char)code);
                    }
                    String dataAsString = this.getDataAsString(data);
                    if (this.permissive && code == 31) {
                        code = data[0];
                        dataAsString = dataAsString.substring(1);
                        this.errors.addError(3, "Subfield tag is a subfield separator, using first character of field as subfield tag.");
                    }
                    subfield.setCode((char)code);
                    subfield.setData(dataAsString);
                    dataField.addSubfield(subfield);
                    continue block3;
                }
            }
        }
        return dataField;
    }

    private void cleanupBadFieldSeperators(byte[] field) {
        if (conv == null) {
            conv = new AnselToUnicode(true);
        }
        boolean hasEsc = false;
        boolean inMultiByte = false;
        boolean justCleaned = false;
        int mbOffset = 0;
        int i = 0;
        while (i < field.length - 1) {
            if (field[i] == 27) {
                hasEsc = true;
                if ("(,)-'".indexOf((char)field[i + 1]) != -1) {
                    inMultiByte = false;
                } else if (i + 2 < field.length && field[i + 1] == 36 && field[i + 2] == 49) {
                    inMultiByte = true;
                    mbOffset = 3;
                } else if (!(i + 3 >= field.length || field[i + 1] != 36 && field[i + 2] != 36 || field[i + 2] != 49 && field[i + 3] != 49)) {
                    inMultiByte = true;
                    mbOffset = 4;
                }
            } else if (inMultiByte && field[i] != 32) {
                int n = mbOffset = mbOffset == 0 ? 2 : mbOffset - 1;
            }
            if (inMultiByte && mbOffset == 0 && i + 2 < field.length) {
                int f3;
                int f2;
                int f1 = field[i];
                char c = conv.getMBChar(conv.makeMultibyte((char)(f1 == 31 ? 124 : f1), (char)((f2 = field[i + 1] == 32 ? field[i + 2] : field[i + 1]) == 31 ? 124 : f2), (char)((f3 = field[i + 1] == 32 || field[i + 2] == 32 ? field[i + 3] : field[i + 2]) == 31 ? 124 : f3)));
                if (c == '\u0000' && !justCleaned) {
                    this.errors.addError(3, "Bad Multibyte character found, reinterpreting data as non-multibyte data");
                    inMultiByte = false;
                } else if (c == '\u0000' && justCleaned) {
                    c = conv.getMBChar(conv.makeMultibyte('!', (char)(f2 == 31 ? 124 : f2), (char)(f3 == 31 ? 124 : f3)));
                    if (c == '\u0000') {
                        this.errors.addError(3, "Bad Multibyte character found, reinterpreting data as non-multibyte data");
                        inMultiByte = false;
                    } else {
                        this.errors.addError(3, "Character after restored vertical bar character makes bad multibyte character, changing it to \"!\"");
                        field[i] = 33;
                    }
                }
            }
            justCleaned = false;
            if (field[i] == 31) {
                if (inMultiByte && mbOffset != 0) {
                    field[i] = 124;
                    this.errors.addError(3, "Subfield separator found in middle of a multibyte character, changing it to a vertical bar, and continuing");
                    if (field[i + 1] == 48) {
                        if (field[i + 2] == 40 && field[i + 3] == 66) {
                            field[i + 1] = 27;
                            this.errors.addError(3, "Character after restored vertical bar character makes bad multibyte character, changing it to ESC");
                        } else {
                            field[i + 1] = 33;
                            this.errors.addError(3, "Character after restored vertical bar character makes bad multibyte character, changing it to \"!\"");
                        }
                    }
                    justCleaned = true;
                } else if (!(!hasEsc || field[i + 1] >= 97 && field[i + 1] <= 122 || field[i + 1] >= 48 && field[i + 1] <= 57)) {
                    this.errors.addError(3, "Subfield separator followed by invalid subfield tag, changing separator to a vertical bar, and continuing");
                    field[i] = 124;
                    justCleaned = true;
                } else if (hasEsc && i < field.length - 3 && field[i + 1] == 48 && field[i + 2] == 40 && field[i + 3] == 66) {
                    this.errors.addError(3, "Subfield separator followed by invalid subfield tag, changing separator to a vertical bar, and continuing");
                    field[i] = 124;
                    field[i + 1] = 27;
                    justCleaned = true;
                } else if (hasEsc && field[i + 1] == 48) {
                    this.errors.addError(3, "Subfield separator followed by invalid subfield tag, changing separator to a vertical bar, and continuing");
                    field[i] = 124;
                    field[i + 1] = 33;
                    justCleaned = true;
                } else if (field[i + 1] == 31 && field[i + 2] == 31) {
                    this.errors.addError(3, "Three consecutive subfield separators, changing first two to vertical bars.");
                    field[i] = 124;
                    field[i + 1] = 124;
                    justCleaned = true;
                }
            }
            ++i;
        }
    }

    private int getFieldLength(DataInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    if (this.permissive) {
                        this.errors.addError(2, "Field not terminated trying to continue");
                        return bytesRead;
                    }
                    throw new IOException("Field not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private int getSubfieldLength(ByteArrayInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: {
                    bais.reset();
                    return bytesRead;
                }
                case 31: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    if (this.permissive) {
                        this.errors.addError(2, "Subfield not terminated trying to continue");
                        return bytesRead;
                    }
                    throw new IOException("subfield not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private int parseRecordLength(byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(leaderData));
        int length = -1;
        char[] tmp = new char[5];
        isr.read(tmp);
        try {
            length = Integer.parseInt(new String(tmp));
        }
        catch (NumberFormatException e) {
            this.errors.addError(4, "Unable to parse record length, Unable to Continue");
            throw new MarcException("unable to parse record length", e);
        }
        return length;
    }

    private void parseLeader(Leader ldr, byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(leaderData));
        char[] tmp = new char[5];
        isr.read(tmp);
        ldr.setRecordStatus((char)isr.read());
        ldr.setTypeOfRecord((char)isr.read());
        tmp = new char[2];
        isr.read(tmp);
        ldr.setImplDefined1(tmp);
        ldr.setCharCodingScheme((char)isr.read());
        char indicatorCount = (char)isr.read();
        char subfieldCodeLength = (char)isr.read();
        char[] baseAddr = new char[5];
        isr.read(baseAddr);
        tmp = new char[3];
        isr.read(tmp);
        ldr.setImplDefined2(tmp);
        tmp = new char[4];
        isr.read(tmp);
        ldr.setEntryMap(tmp);
        isr.close();
        try {
            ldr.setIndicatorCount(Integer.parseInt(String.valueOf(indicatorCount)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse indicator count", e);
        }
        try {
            ldr.setSubfieldCodeLength(Integer.parseInt(String.valueOf(subfieldCodeLength)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse subfield code length", e);
        }
        try {
            ldr.setBaseAddressOfData(Integer.parseInt(new String(baseAddr)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse base address of data", e);
        }
    }

    private String getDataAsString(byte[] bytes) {
        String newdataElement;
        String dataElement = null;
        if (this.encoding.equals("UTF-8") || this.encoding.equals("UTF8")) {
            try {
                dataElement = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        }
        if (this.encoding.equals("UTF8-Maybe")) {
            try {
                dataElement = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        }
        if (this.encoding.equals("MARC-8") || this.encoding.equals("MARC8")) {
            dataElement = this.getMarc8Conversion(bytes);
        } else if (this.encoding.equalsIgnoreCase("Unimarc") || this.encoding.equals("IS05426")) {
            dataElement = this.getUnimarcConversion(bytes);
        } else if (this.encoding.equals("MARC8-Maybe")) {
            String dataElement1 = this.getMarc8Conversion(bytes);
            String dataElement2 = this.getUnimarcConversion(bytes);
            String dataElement3 = null;
            try {
                dataElement3 = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (dataElement1.equals(dataElement2) && dataElement1.equals(dataElement3)) {
                dataElement = dataElement1;
            } else {
                this.conversionCheck1 = String.valueOf(this.conversionCheck1) + "|>" + Normalizer.compose((String)dataElement1, (boolean)false);
                this.conversionCheck2 = String.valueOf(this.conversionCheck2) + "|>" + dataElement2;
                this.conversionCheck3 = String.valueOf(this.conversionCheck3) + "|>" + dataElement3;
                dataElement = String.valueOf(dataElement1) + "%%@%%" + dataElement2 + "%%@%%" + dataElement3;
            }
        } else if (this.encoding.equals("MARC8-Broken")) {
            try {
                dataElement = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            newdataElement = dataElement.replaceAll("&lt;", "<");
            newdataElement = newdataElement.replaceAll("&gt;", ">");
            newdataElement = newdataElement.replaceAll("&amp;", "&");
            newdataElement = newdataElement.replaceAll("&apos;", "'");
            newdataElement = newdataElement.replaceAll("&quot;", "\"");
            if (!newdataElement.equals(dataElement)) {
                dataElement = newdataElement;
                this.errors.addError(1, "Subfield contains escaped html character entities, un-escaping them. ");
            }
            String rep1 = "\u001b\\$1$1";
            String rep2 = "\u001b\\(B";
            newdataElement = dataElement.replaceAll("\\$1(.)", rep1);
            if (!(newdataElement = newdataElement.replaceAll("\\(B", rep2)).equals(dataElement)) {
                dataElement = newdataElement;
                this.errors.addError(3, "Subfield seems to be missing MARC8 escape sequences, trying to restore them.");
            }
            try {
                dataElement = this.getMarc8Conversion(dataElement.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (this.encoding.equals("ISO-8859-1") || this.encoding.equals("ISO8859_1")) {
            try {
                dataElement = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        } else {
            throw new MarcException("Unknown or unsupported Marc character encoding:" + this.encoding);
        }
        if (this.errors != null && dataElement.matches("[^&]*&[a-z]*;.*")) {
            newdataElement = dataElement.replaceAll("&lt;", "<");
            newdataElement = newdataElement.replaceAll("&gt;", ">");
            newdataElement = newdataElement.replaceAll("&amp;", "&");
            newdataElement = newdataElement.replaceAll("&apos;", "'");
            if (!(newdataElement = newdataElement.replaceAll("&quot;", "\"")).equals(dataElement)) {
                dataElement = newdataElement;
                this.errors.addError(1, "Subfield contains escaped html character entities, un-escaping them. ");
            }
        }
        return dataElement;
    }

    private boolean byteArrayContains(byte[] bytes, byte[] seq) {
        int i = 0;
        while (i < bytes.length - seq.length) {
            if (bytes[i] == seq[0]) {
                int j = 0;
                while (j < seq.length) {
                    if (bytes[i + j] != seq[j]) break;
                    if (j == seq.length - 1) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private String getMarc8Conversion(byte[] bytes) {
        String dataElement = null;
        if (this.converterAnsel == null) {
            this.converterAnsel = new AnselToUnicode(this.errors);
        }
        if (this.permissive && (this.byteArrayContains(bytes, badEsc) || this.byteArrayContains(bytes, overbar))) {
            String newDataElement = null;
            try {
                dataElement = new String(bytes, "ISO-8859-1");
                newDataElement = dataElement.replaceAll("(\\e)b-\\es([psb])", "$1$2");
                if (!newDataElement.equals(dataElement)) {
                    dataElement = newDataElement;
                    this.errors.addError(2, "Subfield contains odd pattern of subscript or superscript escapes. ");
                }
                if (!(newDataElement = dataElement.replace('\u00af', '\u00e5')).equals(dataElement)) {
                    dataElement = newDataElement;
                    this.errors.addError(1, "Subfield contains 0xaf overbar character, changing it to proper MARC8 representation ");
                }
                dataElement = this.converterAnsel.convert(dataElement);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            dataElement = this.converterAnsel.convert(bytes);
        }
        if (this.permissive && dataElement.matches("[^&]*&#x[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f];.*")) {
            Pattern pattern = Pattern.compile("&#x([0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]);");
            Matcher matcher = pattern.matcher(dataElement);
            StringBuffer newElement = new StringBuffer();
            int prevEnd = 0;
            while (matcher.find()) {
                newElement.append(dataElement.substring(prevEnd, matcher.start()));
                newElement.append(this.getChar(matcher.group(1)));
                prevEnd = matcher.end();
            }
            newElement.append(dataElement.substring(prevEnd));
            dataElement = newElement.toString();
        }
        return dataElement;
    }

    private String getUnimarcConversion(byte[] bytes) {
        if (this.converterUnimarc == null) {
            this.converterUnimarc = new Iso5426ToUnicode();
        }
        String dataElement = this.converterUnimarc.convert(bytes);
        dataElement = dataElement.replaceAll("\u0088", "");
        if ((dataElement = dataElement.replaceAll("\u0089", "")).matches("[^<]*<U[+][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]>.*")) {
            Pattern pattern = Pattern.compile("<U[+]([0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f])>");
            Matcher matcher = pattern.matcher(dataElement);
            StringBuffer newElement = new StringBuffer();
            int prevEnd = 0;
            while (matcher.find()) {
                newElement.append(dataElement.substring(prevEnd, matcher.start()));
                newElement.append(this.getChar(matcher.group(1)));
                prevEnd = matcher.end();
            }
            newElement.append(dataElement.substring(prevEnd));
            dataElement = newElement.toString();
        }
        return dataElement;
    }

    private String getChar(String charCodePoint) {
        int charNum = Integer.parseInt(charCodePoint, 16);
        String result = "" + (char)charNum;
        return result;
    }
}

