/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.MarcException;
import org.marc4j.converter.impl.CodeTableHandler;
import org.marc4j.converter.impl.CodeTableInterface;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CodeTable
implements CodeTableInterface {
    protected static HashMap charsets = null;
    protected static HashMap combining = null;

    public boolean isCombining(int i, int g0, int g1) {
        if (i <= 126) {
            Vector v = (Vector)combining.get(new Integer(g0));
            return v != null && v.contains(new Integer(i));
        }
        Vector v = (Vector)combining.get(new Integer(g1));
        return v != null && v.contains(new Integer(i));
    }

    public char getChar(int c, int mode) {
        if (c == 32) {
            return (char)c;
        }
        HashMap charset = (HashMap)charsets.get(new Integer(mode));
        if (charset == null) {
            return (char)c;
        }
        Character ch = (Character)charset.get(new Integer(c));
        if (ch == null) {
            int newc = c < 128 ? c + 128 : c - 128;
            ch = (Character)charset.get(new Integer(newc));
            if (ch == null) {
                return '\u0000';
            }
            return ch.charValue();
        }
        return ch.charValue();
    }

    public CodeTable(InputStream byteStream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(byteStream);
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public CodeTable(String filename) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File(filename);
            InputSource src = new InputSource(new FileInputStream(file));
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public CodeTable(URI uri) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(uri.toURL().openStream());
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }
}

