/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader;

import org.apache.jena.atlas.lib.ProgressMonitor;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.jenax.Txn;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.ProgressStreamRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.tdb2.loader.StreamRDFBatchSplit;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader {
    private static final int BATCH_SIZE = 100;
    private static Logger LOG = LoggerFactory.getLogger((String)"Loader");

    public static void bulkLoad(Dataset ds, String ... files) {
        ProgressStreamRDF sMonitor;
        DatasetGraphTDB dsg = (DatasetGraphTDB)ds.asDatasetGraph();
        StreamRDF s1 = StreamRDFLib.dataset((DatasetGraph)dsg);
        ProgressMonitor plog = ProgressMonitor.create((Logger)LOG, (String)"Triples", (long)100000L, (int)10);
        ProgressStreamRDF s3 = sMonitor = new ProgressStreamRDF(s1, plog);
        plog.start();
        Txn.executeWrite((Transactional)ds, () -> Loader.lambda$bulkLoad$0(files, (StreamRDF)s3));
        plog.finish();
        plog.finishMessage();
    }

    public static void bulkLoadBatching(Dataset ds, String ... files) {
        DatasetGraphTDB dsg = (DatasetGraphTDB)ds.asDatasetGraph();
        StreamRDFBatchSplit s1 = new StreamRDFBatchSplit(dsg, 10);
        ProgressMonitor plog = ProgressMonitor.create((Logger)LOG, (String)"Triples", (long)100000L, (int)100);
        ProgressStreamRDF s3 = new ProgressStreamRDF((StreamRDF)s1, plog);
        plog.start();
        Txn.executeWrite((Transactional)ds, () -> Loader.lambda$bulkLoadBatching$1(files, (StreamRDF)s3));
        plog.finish();
        plog.finishMessage();
    }

    private static /* synthetic */ void lambda$bulkLoadBatching$1(String[] files, StreamRDF s3) {
        for (String fn : files) {
            if (files.length > 1) {
                FmtLog.info((Logger)LOG, (String)"File: %s", (Object[])new Object[]{fn});
            }
            RDFDataMgr.parse((StreamRDF)s3, (String)fn);
        }
    }

    private static /* synthetic */ void lambda$bulkLoad$0(String[] files, StreamRDF s3) {
        for (String fn : files) {
            if (files.length > 1) {
                FmtLog.info((Logger)LOG, (String)"File: %s", (Object[])new Object[]{fn});
            }
            RDFDataMgr.parse((StreamRDF)s3, (String)fn);
        }
    }
}

