/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.tdb2.solver.stats.StatsCollectorBase;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;

public class StatsCollectorNodeId
extends StatsCollectorBase<NodeId> {
    private NodeTable nodeTable;

    public StatsCollectorNodeId(NodeTable nodeTable) {
        super(StatsCollectorNodeId.findRDFType(nodeTable));
        this.nodeTable = nodeTable;
    }

    private static NodeId findRDFType(NodeTable nodeTable2) {
        return nodeTable2.getAllocateNodeId(NodeConst.nodeRDFType);
    }

    @Override
    protected Map<Node, Integer> convert(Map<NodeId, Integer> stats) {
        HashMap<Node, Integer> statsNodes = new HashMap<Node, Integer>(1000);
        for (NodeId p : stats.keySet()) {
            Node n = this.nodeTable.getNodeForNodeId(p);
            statsNodes.put(n, stats.get(p));
        }
        return statsNodes;
    }
}

