/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingCache
implements PrefixMapping {
    private final PrefixMapping other;
    private Cache<String, String> prefixToUri = CacheFactory.createCache((int)100);
    private Cache<String, String> uriToPrefix = CacheFactory.createCache((int)100);

    public PrefixMappingCache(PrefixMapping other) {
        this.other = other;
    }

    private void add(String prefix, String uri) {
        this.prefixToUri.put((Object)prefix, (Object)uri);
        this.uriToPrefix.put((Object)uri, (Object)prefix);
    }

    private void remove(String prefix, String uri) {
        this.prefixToUri.remove((Object)prefix);
        this.uriToPrefix.remove((Object)uri);
    }

    private void clear() {
        this.prefixToUri.clear();
        this.uriToPrefix.clear();
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.other.setNsPrefix(prefix, uri);
        this.add(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        String uri = this.getNsPrefixURI(prefix);
        if (uri != null) {
            this.remove(prefix, uri);
        }
        this.other.removeNsPrefix(prefix);
        return this;
    }

    public PrefixMapping clearNsPrefixMap() {
        this.prefixToUri.clear();
        this.uriToPrefix.clear();
        this.other.clearNsPrefixMap();
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping pmap) {
        this.setNsPrefixes(pmap.getNsPrefixMap());
        return this;
    }

    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        map.entrySet().forEach(entry -> this.setNsPrefix((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        this.other.withDefaultMappings(map);
        this.clear();
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        String x = (String)this.prefixToUri.getIfPresent((Object)prefix);
        if (x == null && (x = this.other.getNsPrefixURI(prefix)) != null) {
            this.prefixToUri.put((Object)prefix, (Object)x);
        }
        return x;
    }

    public String getNsURIPrefix(String uri) {
        String x = (String)this.uriToPrefix.getIfPresent((Object)uri);
        if (x == null && (x = this.other.getNsURIPrefix(uri)) != null) {
            this.uriToPrefix.put((Object)uri, (Object)x);
        }
        return x;
    }

    public Map<String, String> getNsPrefixMap() {
        return this.other.getNsPrefixMap();
    }

    public String expandPrefix(String prefixed) {
        int colon = prefixed.indexOf(58);
        if (colon < 0) {
            return prefixed;
        }
        String prefix = prefixed.substring(0, colon);
        String uri = this.getNsPrefixURI(prefix);
        return uri == null ? prefixed : uri + prefixed.substring(colon + 1);
    }

    public String qnameFor(String uri) {
        int split = Util.splitNamespaceXML((String)uri);
        String ns = uri.substring(0, split);
        String local = uri.substring(split);
        if (local.equals("")) {
            return null;
        }
        String prefix = this.getNsURIPrefix(ns);
        return prefix == null ? null : prefix + ":" + local;
    }

    public String shortForm(String uri) {
        Optional<Map.Entry<String, String>> e = this.findMapping(uri, true);
        if (!e.isPresent()) {
            return uri;
        }
        return e.get().getKey() + ":" + uri.substring(e.get().getValue().length());
    }

    private Optional<Map.Entry<String, String>> findMapping(String uri, boolean partial) {
        return ((Stream)this.getNsPrefixMap().entrySet().stream().sequential()).filter(e -> {
            String ss = (String)e.getValue();
            return uri.startsWith(ss) && (partial || ss.length() == uri.length());
        }).findFirst();
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return other.samePrefixMappingAs(other);
    }

    public PrefixMapping lock() {
        return this;
    }

    public boolean hasNoMappings() {
        return this.other.hasNoMappings();
    }

    public int numPrefixes() {
        return this.other.numPrefixes();
    }

    private static String str(PrefixMapping pmap) {
        return pmap.getNsPrefixMap().toString();
    }

    public String toString() {
        String x = Iter.iter((Iterator)this.prefixToUri.keys()).map(k -> k + "->" + (String)this.prefixToUri.getIfPresent(k)).asString(", ");
        return "pm cache: [" + this.prefixToUri.size() + "] " + x + " : " + PrefixMappingCache.str(this.other);
    }
}

