/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AccumulatingRingBufferDouble
implements Iterable<Double> {
    private final double[] buffer;
    private int fill = 0;
    private int start = 0;
    private BigDecimal sum = BigDecimal.ZERO;

    public AccumulatingRingBufferDouble(int capacity) {
        this.buffer = new double[capacity];
    }

    public void add(double value) {
        int i = this.indexOf(this.getN());
        if (this.willAddOverwrite()) {
            this.removeValueFormSumAt(0);
            this.advance(1);
        } else {
            ++this.fill;
        }
        this.buffer[i] = value;
        this.addToSum(value);
    }

    public void removeNewestN(int n) {
        if (this.getN() < n) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.removeValueFormSumAt(this.fill - i - 1);
        }
        this.fill -= n;
    }

    public void removeOldestN(int n) {
        if (this.getN() < n) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.removeValueFormSumAt(i);
        }
        this.advance(n);
        this.fill -= n;
    }

    public void clear() {
        this.start = 0;
        this.fill = 0;
    }

    public boolean willAddOverwrite() {
        return this.getN() == this.getCapacity();
    }

    public double get(int index) {
        if (this.getN() == 0) {
            throw new NoSuchElementException();
        }
        return this.getAt(this.getN() - index - 1);
    }

    public double getNewest() {
        if (this.getN() == 0) {
            throw new NoSuchElementException();
        }
        return this.getAt(this.getN() - 1);
    }

    public double getOldest() {
        if (this.getN() == 0) {
            throw new NoSuchElementException();
        }
        return this.getAt(0);
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public int getN() {
        return this.fill;
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < AccumulatingRingBufferDouble.this.getN();
            }

            @Override
            public Double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return AccumulatingRingBufferDouble.this.getAt(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int advance(int n) {
        this.start = (this.start + n) % this.getCapacity();
        return this.start;
    }

    private int indexOf(int index) {
        return (this.start + index) % this.getCapacity();
    }

    private double getAt(int index) {
        return this.buffer[this.indexOf(index)];
    }

    private void addToSum(double value) {
        this.sum = this.sum.add(BigDecimal.valueOf(value));
    }

    private void removeValueFormSumAt(int index) {
        this.sum = this.sum.subtract(BigDecimal.valueOf(this.getAt(index)));
    }
}

