/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AccumulatingRingBufferLong
implements Iterable<Long> {
    private final long[] buffer;
    private int fill = 0;
    private int start = 0;
    private BigInteger sum = BigInteger.ZERO;

    public AccumulatingRingBufferLong(int capacity) {
        this.buffer = new long[capacity];
    }

    public void add(long value) {
        int i = this.indexOf(this.getN());
        if (this.willAddOverwrite()) {
            this.removeValueFormSumAt(0);
            this.advance(1);
        } else {
            ++this.fill;
        }
        this.buffer[i] = value;
        this.addToSum(value);
    }

    public void removeNewestN(int n) {
        if (this.getN() < n) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.removeValueFormSumAt(this.fill - i - 1);
        }
        this.fill -= n;
    }

    public void removeOldestN(int n) {
        if (this.getN() < n) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < n; ++i) {
            this.removeValueFormSumAt(i);
        }
        this.advance(n);
        this.fill -= n;
    }

    public void clear() {
        this.start = 0;
        this.fill = 0;
    }

    public boolean willAddOverwrite() {
        return this.getN() == this.getCapacity();
    }

    public long get(int index) {
        if (this.getN() == 0) {
            throw new NoSuchElementException();
        }
        return this.getAt(this.getN() - index - 1);
    }

    public long getNewest() {
        if (this.getN() == 0) {
            throw new NoSuchElementException();
        }
        return this.getAt(this.getN() - 1);
    }

    public long getOldest() {
        if (this.getN() == 0) {
            throw new NoSuchElementException();
        }
        return this.getAt(0);
    }

    public BigInteger getSum() {
        return this.sum;
    }

    public int getN() {
        return this.fill;
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < AccumulatingRingBufferLong.this.getN();
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return AccumulatingRingBufferLong.this.getAt(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int advance(int n) {
        this.start = (this.start + n) % this.getCapacity();
        return this.start;
    }

    private int indexOf(int index) {
        return (this.start + index) % this.getCapacity();
    }

    private long getAt(int index) {
        return this.buffer[this.indexOf(index)];
    }

    private void addToSum(long value) {
        this.sum = this.sum.add(BigInteger.valueOf(value));
    }

    private void removeValueFormSumAt(int index) {
        this.sum = this.sum.subtract(BigInteger.valueOf(this.getAt(index)));
    }
}

