/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;

public class PrinterBase {
    private final Stack<State> stateStack = new Stack();
    private final ArrayList<String> indentStrings = new ArrayList<String>(Arrays.asList(""));
    private PrintWriter out;
    private String indentString = "\t";
    private int indent = 0;
    private int hadNewlines = 1;
    private int needNewlines = 0;
    private int eatNewlines = 0;
    private final HashMap<Memoize, Memoize> cache = new HashMap();
    private int reuse = 0;
    private boolean memoize = true;

    public PrinterBase(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public State push() {
        State state = this.getState();
        this.stateStack.push(state);
        return state;
    }

    public State pop() {
        return this.stateStack.pop();
    }

    public State restore() {
        State state = this.stateStack.pop();
        this.setState(state);
        return state;
    }

    private State getState() {
        return new State(this.out, this.indent, this.hadNewlines, this.needNewlines, this.eatNewlines);
    }

    public void setState(State state) {
        this.out = state.out;
        this.indent = state.indent;
        this.hadNewlines = state.hadNewlines;
        this.needNewlines = state.needNewlines;
        this.eatNewlines = state.eatNewlines;
    }

    public void setStateNotOut(State state) {
        this.indent = state.indent;
        this.hadNewlines = state.hadNewlines;
        this.needNewlines = state.needNewlines;
        this.eatNewlines = state.eatNewlines;
    }

    public OutputBuffer outputBufferStart() {
        return new OutputBuffer();
    }

    public void incIndent() {
        ++this.indent;
        while (this.indentStrings.size() <= this.indent) {
            this.indentStrings.add(this.indentStrings.get(this.indentStrings.size() - 1) + this.indentString);
        }
    }

    public void decIndent() {
        assert (this.indent > 0);
        --this.indent;
    }

    public void indent() {
        if (this.eatNewlines > 0) {
            --this.eatNewlines;
        } else {
            this.needNewlines(1);
            if (this.indent > 0) {
                this.print(this.indentStrings.get(this.indent));
            }
        }
    }

    public void indent(String text) {
        this.indent();
        this.print(text);
    }

    public void indent(char ch) {
        this.indent();
        this.print(ch);
    }

    public void indentln(char ch) {
        this.indent();
        this.println(ch);
    }

    public void indentln(String text) {
        this.indent();
        this.println(text);
    }

    public void indentAtBol() {
        if (this.atBol()) {
            this.indent();
        }
    }

    public void indentAtBol(String text) {
        this.indentAtBol();
        this.print(text);
    }

    public void indentAtBol(char ch) {
        this.indentAtBol();
        this.print(ch);
    }

    public void indentlnAtBol(char ch) {
        this.indentAtBol();
        this.println(ch);
    }

    public void indentlnAtBol(String text) {
        this.indentAtBol();
        this.println(text);
    }

    public void ignoreNewlines() {
        this.needNewlines = 0;
    }

    public void eatNewlinesAndIndents(int i) {
        this.eatNewlines += i;
    }

    public void clearEatNewlinesAndIndents() {
        this.eatNewlines = 0;
    }

    public void print(char ch) {
        if (ch == '\n') {
            this.println();
        } else {
            this.flush();
            this.out.print(ch);
            this.hadNewlines = 0;
            this.eatNewlines = 0;
        }
    }

    public void print(String text) {
        int from = 0;
        int length = text.length();
        while (from < length) {
            int to;
            boolean hadNewline = false;
            int lineSepLength = 1;
            for (to = from; to < length; ++to) {
                char ch = text.charAt(to);
                if (ch == '\r') {
                    hadNewline = true;
                    if (to + 1 >= length || text.charAt(to) != '\n') break;
                    lineSepLength = 2;
                    break;
                }
                if (ch != '\n') continue;
                hadNewline = true;
                break;
            }
            if (to > from) {
                this.flush();
                this.out.print(text.substring(from, to));
                this.hadNewlines = 0;
                this.eatNewlines = 0;
            }
            if (hadNewline) {
                this.println();
            }
            from = to + lineSepLength;
        }
    }

    public void verbatim(String text) {
        this.flush();
        this.out.print(text);
        this.hadNewlines = text.isEmpty() || text.charAt(text.length() - 1) != '\n' ? 0 : 1;
    }

    public void println() {
        this.needNewlines(1);
    }

    public void println(char ch) {
        this.print(ch);
        this.needNewlines(1);
    }

    public void println(String text) {
        this.print(text);
        this.needNewlines(1);
    }

    public void println(Object o) {
        this.print(o.toString());
        this.needNewlines(1);
    }

    public void needNewlines(int i) {
        if (i > this.needNewlines) {
            this.needNewlines = i;
        }
    }

    public void capNewlines(int min, int max) {
        this.needNewlines = Math.max(min, Math.min(max, this.needNewlines));
    }

    public boolean atBol() {
        return this.needNewlines > this.eatNewlines || this.hadNewlines > 0;
    }

    public void forceln() {
        int newlines = this.needNewlines - this.hadNewlines;
        while (newlines-- > 0) {
            if (this.eatNewlines > 0) {
                --this.eatNewlines;
                continue;
            }
            this.out.println();
            ++this.hadNewlines;
        }
        this.needNewlines = 0;
    }

    public void flush() {
        this.forceln();
    }

    public void setMemoize(boolean memoize) {
        this.memoize = memoize;
    }

    public boolean isMemoize() {
        return this.memoize;
    }

    public Memoize memoizeStart(Object node) {
        if (!this.memoize) {
            return new Memoize(null, (State)null);
        }
        Memoize m = this.cache.get(new Memoize(node, this.getState()));
        if (m == null) {
            return new Memoize(node, this.outputBufferStart());
        }
        ++this.reuse;
        m.getOutputBuffer().flush();
        return null;
    }

    public void memoizeStop(Memoize m) {
        if (this.memoize) {
            m.getOutputBuffer().flush();
            this.cache.put(m, m);
        }
    }

    public void printMemoizationStats() {
        System.out.format("% 6d / % 6d / %2.2f\n", this.cache.size(), this.reuse, Float.valueOf((float)this.reuse / (float)this.cache.size()));
    }

    public static final class Memoize {
        private final Object o;
        private final State state;
        private final OutputBuffer outputBuffer;

        public Memoize(Object node, State state) {
            this.o = node;
            this.state = state;
            this.outputBuffer = null;
        }

        public Memoize(Object node, OutputBuffer outputBuffer) {
            this.o = node;
            this.state = outputBuffer.getStateOnStart();
            this.outputBuffer = outputBuffer;
        }

        public OutputBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.o == null ? 0 : this.o.hashCode());
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Memoize other = (Memoize)obj;
            if (this.o == null ? other.o != null : this.o != other.o) {
                return false;
            }
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }
    }

    public final class OutputBuffer {
        private StringWriter w = new StringWriter();
        private State stateOnStart;
        private State stateOnStop;

        public OutputBuffer() {
            this.stateOnStart = PrinterBase.this.push();
            PrinterBase.this.out = new PrintWriter(this.w);
        }

        public void stop() {
            if (this.isStopped()) {
                throw new UnsupportedOperationException("Already stopped!");
            }
            this.stateOnStop = PrinterBase.this.getState();
            PrinterBase.this.restore();
        }

        public boolean isStopped() {
            return this.stateOnStop != null;
        }

        public String getBuffer() {
            return this.w.toString();
        }

        public void flush() {
            if (!this.isStopped()) {
                this.stop();
            }
            PrinterBase.this.setStateNotOut(this.stateOnStop);
            PrinterBase.this.out.append(this.getBuffer());
        }

        public State getStateOnStart() {
            return this.stateOnStart;
        }

        public State getStateOnStop() {
            return this.stateOnStop;
        }
    }

    private static final class State {
        public PrintWriter out;
        public int indent;
        public int hadNewlines;
        public int needNewlines;
        public int eatNewlines;

        public State(PrintWriter out, int indent, int hadNewlines, int needNewlines, int eatNewlines) {
            this.out = out;
            this.indent = indent;
            this.hadNewlines = hadNewlines;
            this.needNewlines = needNewlines;
            this.eatNewlines = eatNewlines;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.eatNewlines;
            result = 31 * result + this.hadNewlines;
            result = 31 * result + this.indent;
            result = 31 * result + this.needNewlines;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.eatNewlines != other.eatNewlines) {
                return false;
            }
            if (this.hadNewlines != other.hadNewlines) {
                return false;
            }
            if (this.indent != other.indent) {
                return false;
            }
            return this.needNewlines == other.needNewlines;
        }
    }
}

