/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.visitor;

import de.fau.cs.osr.utils.visitor.VisitNotFoundException;
import de.fau.cs.osr.utils.visitor.VisitingException;
import de.fau.cs.osr.utils.visitor.VisitorInterface;
import de.fau.cs.osr.utils.visitor.VisitorLogic;

public abstract class VisitorBase<T>
extends VisitorInterface<T> {
    private final VisitorLogic<T> logic;

    public VisitorBase() {
        this.logic = new VisitorLogic(this);
    }

    public VisitorBase(VisitorLogic<T> logic) {
        this.logic = logic;
    }

    @Override
    protected abstract Object dispatch(T var1);

    @Override
    protected T before(T node) {
        return node;
    }

    @Override
    protected Object after(T node, Object result) {
        return result;
    }

    @Override
    protected Object visitNotFound(T node) {
        throw new VisitNotFoundException(this, node);
    }

    @Override
    protected Object handleVisitingException(T node, Throwable cause) {
        throw new VisitingException(node, cause);
    }

    public Object go(T node) {
        T startNode = this.before(node);
        if (startNode == null) {
            return null;
        }
        Object result = this.dispatch(startNode);
        return this.after(node, result);
    }

    protected final Object resolveAndVisit(T node) {
        return this.logic.resolveAndVisit(node);
    }
}

