/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.visitor;

import de.fau.cs.osr.utils.visitor.MultipleVisitMethodsMatchException;
import de.fau.cs.osr.utils.visitor.VisitNotFoundException;
import de.fau.cs.osr.utils.visitor.VisitingException;
import de.fau.cs.osr.utils.visitor.VisitorException;
import de.fau.cs.osr.utils.visitor.VisitorInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class VisitorLogic<T> {
    private static final int LOWER_CAPACITY = 256;
    private static final int UPPER_CAPACITY = 384;
    private static final float LOAD_FACTOR = 0.6f;
    private static final ConcurrentHashMap<Target, Target> CACHE = new ConcurrentHashMap(256, 0.6f);
    private VisitorInterface<T> visitorImpl;

    public VisitorLogic(VisitorInterface<T> visitorImpl) {
        this.visitorImpl = visitorImpl;
    }

    public final Object go(T node) {
        T startNode = this.visitorImpl.before(node);
        if (startNode == null) {
            return null;
        }
        Object result = this.visitorImpl.dispatch(startNode);
        return this.visitorImpl.after(node, result);
    }

    public void setImpl(VisitorInterface<T> visitorImpl) {
        this.visitorImpl = visitorImpl;
    }

    public VisitorInterface<T> getImpl() {
        return this.visitorImpl;
    }

    public static <T> Object dispatchTo(VisitorInterface<T> modeImpl, T n) {
        return VisitorLogic.resolveAndVisit(modeImpl, n);
    }

    protected final Object resolveAndVisit(T node) {
        return VisitorLogic.resolveAndVisit(this.visitorImpl, node);
    }

    protected static <T> Object resolveAndVisit(VisitorInterface<T> visitorImpl, T node) {
        Class<?> vClass = visitorImpl.getClass();
        Class<?> nClass = node.getClass();
        Target key = new Target(vClass, nClass);
        Target cached = CACHE.get(key);
        try {
            if (cached == null) {
                cached = VisitorLogic.findVisit(key);
            }
            if (cached.getMethod() == null) {
                return visitorImpl.visitNotFound(node);
            }
            return cached.invoke(visitorImpl, node);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VisitingException) {
                throw (VisitingException)cause;
            }
            return visitorImpl.handleVisitingException(node, cause);
        }
        catch (VisitingException e) {
            throw e;
        }
        catch (VisitNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitorException(node, (Throwable)e);
        }
    }

    private static Target findVisit(Target key) throws SecurityException, NoSuchMethodException {
        Target target;
        Target cached;
        Method method = null;
        final Class<?> vClass = key.getVClass();
        final Class<?> nClass = key.getNClass();
        ArrayList<Class> candidates = new ArrayList<Class>();
        ArrayDeque work = new ArrayDeque();
        work.add(nClass);
        while (!work.isEmpty()) {
            Class workItem = (Class)work.remove();
            try {
                method = vClass.getMethod("visit", workItem);
                candidates.add(workItem);
            }
            catch (NoSuchMethodException e) {
                Class superclass = workItem.getSuperclass();
                if (superclass != null) {
                    work.add(superclass);
                }
                for (Class<?> i : workItem.getInterfaces()) {
                    work.add(i);
                }
            }
        }
        if (!candidates.isEmpty()) {
            Collections.sort(candidates, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> arg0, Class<?> arg1) {
                    if (arg0 == arg1) {
                        return 0;
                    }
                    if (arg0.isAssignableFrom(arg1)) {
                        return 1;
                    }
                    if (arg1.isAssignableFrom(arg0)) {
                        return -1;
                    }
                    throw new MultipleVisitMethodsMatchException(vClass, nClass, arg0, arg1);
                }
            });
            method = vClass.getMethod("visit", (Class)candidates.get(0));
        }
        if ((cached = CACHE.putIfAbsent(target = new Target(key, method), target)) != null) {
            return cached;
        }
        target.touch();
        if (CACHE.size() > 384) {
            VisitorLogic.sweepCache();
        }
        return target;
    }

    private static synchronized void sweepCache() {
        if (CACHE.size() <= 384) {
            return;
        }
        Target[] keys = new Target[CACHE.size()];
        Enumeration<Target> keysEnum = CACHE.keys();
        int i = 0;
        while (i < keys.length && keysEnum.hasMoreElements()) {
            keys[i++] = keysEnum.nextElement();
        }
        int length = i;
        int to = length - 256;
        VisitorLogic.quickSelect(keys, length, to);
        for (int j = 0; j < to; ++j) {
            CACHE.remove(keys[j]);
        }
    }

    private static void quickSelect(Target[] keys, int length, int to) {
        int left = 0;
        int right = length - 1;
        while (right >= left) {
            int pivot = left + (right - left) / 2;
            if ((pivot = VisitorLogic.partition(keys, left, right, pivot)) == to) break;
            if (pivot < to) {
                left = pivot + 1;
                continue;
            }
            right = pivot - 1;
        }
    }

    private static int partition(Target[] keys, int left, int right, int pivot) {
        long pivotValue = keys[pivot].lastUse;
        VisitorLogic.swap(keys, pivot, right);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (keys[i].lastUse >= pivotValue) continue;
            VisitorLogic.swap(keys, storeIndex, i);
            ++storeIndex;
        }
        VisitorLogic.swap(keys, right, storeIndex);
        return storeIndex;
    }

    private static void swap(Target[] keys, int a, int b) {
        if (a != b) {
            Target tmp = keys[a];
            keys[a] = keys[b];
            keys[b] = tmp;
        }
    }

    protected static final class Target
    implements Comparable<Target> {
        private static long useCounter = 0L;
        private long lastUse = -1L;
        private final Class<?> vClass;
        private final Class<?> nClass;
        private final Method method;

        public Target(Class<?> vClass, Class<?> nClass) {
            this.vClass = vClass;
            this.nClass = nClass;
            this.method = null;
        }

        public Target(Target key, Method method) {
            this.vClass = key.vClass;
            this.nClass = key.nClass;
            this.method = method;
        }

        public Class<?> getVClass() {
            return this.vClass;
        }

        public Class<?> getNClass() {
            return this.nClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.nClass.hashCode();
            result = 31 * result + this.vClass.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            Target other = (Target)obj;
            if (this.nClass != other.nClass) {
                return false;
            }
            return this.vClass == other.vClass;
        }

        public void touch() {
            this.lastUse = ++useCounter;
        }

        public Object invoke(VisitorInterface<?> visitor, Object node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.touch();
            return this.method.invoke(visitor, node);
        }

        @Override
        public int compareTo(Target o) {
            return this.lastUse < o.lastUse ? -1 : 1;
        }

        public String toString() {
            return String.format("Target [%d - %s; %s:%s]", this.lastUse, this.method != null ? "O" : "X", this.vClass.getSimpleName(), this.nClass.getSimpleName());
        }
    }
}

