/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tests;

import com.metaweb.lessen.Utilities;
import com.metaweb.lessen.tokenizers.CondensingTokenizer;
import com.metaweb.lessen.tokenizers.IndentingTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokenizers.UrlRewritingTokenizer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class TestLessParsing {
    public static void main(String[] args) {
        try {
            TestLessParsing.testLess("tests/module-foo/dialog-x/dialog-x.css");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testLess(String filePath) throws IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("module", "foo");
        variables.put("theme", "midnight");
        Tokenizer tokenizer = Utilities.openLess(new File(filePath), variables);
        tokenizer = new UrlRewritingTokenizer(tokenizer, "../modules/foo/styles/");
        tokenizer = new CondensingTokenizer(tokenizer);
        tokenizer = new IndentingTokenizer(tokenizer);
        System.out.println("\n\n---------- Parsing LESS file " + filePath + " ----------");
        Utilities.print(tokenizer, System.out);
    }
}

