/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino.clustering;

import com.wcohen.ss.api.Token;
import edu.mit.simile.vicino.NGramTokenizer;
import edu.mit.simile.vicino.clustering.Clusterer;
import edu.mit.simile.vicino.distances.Distance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NGramClusterer
extends Clusterer {
    NGramTokenizer _tokenizer;
    Distance _distance;
    Map<String, Set<String>> blocks = new HashMap<String, Set<String>>();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final boolean MULTITHREADED = true;

    public NGramClusterer(Distance d, int blockSize) {
        this._tokenizer = new NGramTokenizer(blockSize);
        this._distance = d;
    }

    @Override
    public void populate(String s) {
        Token[] tokens;
        for (Token t : tokens = this._tokenizer.tokenize(s)) {
            String ss = t.getValue();
            Set<Object> l = null;
            if (!this.blocks.containsKey(ss)) {
                l = new TreeSet();
                this.blocks.put(ss, l);
            } else {
                l = this.blocks.get(ss);
            }
            l.add(s);
        }
    }

    @Override
    public List<Set<Serializable>> getClusters(double radius) {
        return this.getClustersMultiThread(radius);
    }

    public List<Set<Serializable>> getClustersMultiThread(double radius) {
        int cores = Runtime.getRuntime().availableProcessors();
        int size = this.blocks.size();
        int range = size / cores + 1;
        ArrayList cluster_maps = new ArrayList(cores);
        ArrayList<BlockEvaluator> evaluators = new ArrayList<BlockEvaluator>(cores);
        for (int i = 0; i < cores; ++i) {
            int range_start = range * i;
            int range_end = range * (i + 1);
            if (range_end > size) {
                range_end = size;
            }
            evaluators.add(new BlockEvaluator(new ArrayList<Set<String>>(this.blocks.values()), radius, range_start, range_end));
        }
        try {
            List futures = executor.invokeAll(evaluators);
            for (Future future : futures) {
                cluster_maps.add(future.get());
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        HashSet<Set> clusters = new HashSet<Set>();
        for (Map cluster_map : cluster_maps) {
            for (Map.Entry e : cluster_map.entrySet()) {
                Set v = (Set)e.getValue();
                if (v.size() <= 1) continue;
                clusters.add(v);
            }
        }
        ArrayList<Set<Serializable>> sorted_clusters = new ArrayList<Set<Serializable>>(clusters);
        Collections.sort(sorted_clusters, new Clusterer.SizeComparator());
        return sorted_clusters;
    }

    public List<Set<Serializable>> getClustersSingleThread(double radius) {
        HashMap cluster_map = new HashMap();
        for (Set<String> set : this.blocks.values()) {
            if (set.size() < 2) continue;
            for (String a : set) {
                for (String b : set) {
                    double d;
                    if (a == b || cluster_map.containsKey(a) && ((Set)cluster_map.get(a)).contains(b) || cluster_map.containsKey(b) && ((Set)cluster_map.get(b)).contains(a) || !((d = this._distance.d(a, b)) <= radius) && !(radius < 0.0)) continue;
                    Set<String> l = null;
                    if (!cluster_map.containsKey(a)) {
                        l = new TreeSet<String>();
                        l.add(a);
                        cluster_map.put(a, l);
                    } else {
                        l = (Set)cluster_map.get(a);
                    }
                    l.add(b);
                }
            }
        }
        ArrayList<Set<Serializable>> clusters = new ArrayList<Set<Serializable>>();
        for (Map.Entry e : cluster_map.entrySet()) {
            Set v = (Set)e.getValue();
            if (v.size() <= 1) continue;
            clusters.add(v);
        }
        Collections.sort(clusters, new Clusterer.SizeComparator());
        return clusters;
    }

    public class BlockEvaluator
    implements Callable<Map<Serializable, Set<Serializable>>> {
        int start;
        int stop;
        double radius;
        List<Set<String>> blocks;
        Map<Serializable, Set<Serializable>> cluster_map;

        public BlockEvaluator(List<Set<String>> blocks, double radius, int start, int stop) {
            this.blocks = blocks;
            this.start = start;
            this.stop = stop;
            this.radius = radius;
        }

        @Override
        public Map<Serializable, Set<Serializable>> call() {
            HashMap<Serializable, Set<Serializable>> cluster_map = new HashMap<Serializable, Set<Serializable>>();
            for (int i = this.start; i < this.stop; ++i) {
                Set<String> set = this.blocks.get(i);
                if (set.size() < 2) continue;
                for (String a : set) {
                    for (String b : set) {
                        double d;
                        if (a == b || cluster_map.containsKey(a) && ((Set)cluster_map.get(a)).contains(b) || cluster_map.containsKey(b) && ((Set)cluster_map.get(b)).contains(a) || !((d = NGramClusterer.this._distance.d(a, b)) <= this.radius) && !(this.radius < 0.0)) continue;
                        Set<String> l = null;
                        if (!cluster_map.containsKey(a)) {
                            l = new TreeSet<String>();
                            l.add(a);
                            cluster_map.put((Serializable)((Object)a), l);
                        } else {
                            l = (Set)cluster_map.get(a);
                        }
                        l.add(b);
                    }
                }
            }
            return cluster_map;
        }
    }
}

