/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.dboe.sys.Sys;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;

public class ThreadTxn {
    private final Semaphore semaStart;
    private final Semaphore semaFinish;
    private final AtomicReference<RuntimeException> thrownRuntimeException = new AtomicReference<Object>(null);
    private final AtomicReference<Error> thrownError = new AtomicReference<Object>(null);
    private final Runnable action;
    private static Executor executor = Sys.executor;

    public static ThreadTxn threadTxnRead(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, ReadWrite.READ, action, false);
    }

    public static ThreadTxn threadTxnWrite(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, ReadWrite.WRITE, action, true);
    }

    public static ThreadTxn threadTxnWriteAbort(Transactional trans, Runnable action) {
        return ThreadTxn.create(trans, ReadWrite.WRITE, action, false);
    }

    private ThreadTxn(Runnable action) {
        this.action = action;
        this.semaStart = new Semaphore(0, true);
        this.semaFinish = new Semaphore(0, true);
    }

    public void run() {
        this.semaStart.release();
        this.semaFinish.acquireUninterruptibly();
        if (this.thrownError.get() != null) {
            throw this.thrownError.get();
        }
        if (this.thrownRuntimeException.get() != null) {
            throw this.thrownRuntimeException.get();
        }
    }

    private void trigger() {
        try {
            this.action.run();
        }
        catch (Error error) {
            this.thrownError.set(error);
            throw error;
        }
        catch (RuntimeException ex) {
            this.thrownRuntimeException.set(ex);
            throw ex;
        }
    }

    static ThreadTxn create(Transactional trans, ReadWrite mode, Runnable action, boolean isCommit) {
        Objects.requireNonNull(trans);
        Objects.requireNonNull(mode);
        Objects.requireNonNull(action);
        ThreadTxn threadAction = new ThreadTxn(action);
        Semaphore semaStartup = new Semaphore(0, true);
        executor.execute(() -> {
            trans.begin(mode);
            semaStartup.release();
            threadAction.semaStart.acquireUninterruptibly();
            try {
                threadAction.trigger();
                if (mode == ReadWrite.WRITE) {
                    if (isCommit) {
                        trans.commit();
                    } else {
                        trans.abort();
                    }
                    trans.end();
                } else {
                    if (isCommit) {
                        trans.commit();
                    }
                    trans.end();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                threadAction.semaFinish.release();
            }
        });
        semaStartup.acquireUninterruptibly();
        return threadAction;
    }
}

