/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIteratorLogging
extends QueryIteratorWrapper {
    private Logger log = null;
    private boolean logging = true;

    public QueryIteratorLogging(QueryIterator input) {
        super(input);
        this.log = LoggerFactory.getLogger(input.getClass());
    }

    @Override
    protected boolean hasNextBinding() {
        boolean b = super.hasNextBinding();
        if (this.logging) {
            this.log.info("hasNextBinding: " + b);
        }
        return b;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding binding = super.moveToNextBinding();
        if (this.logging) {
            this.log.info("moveToNextBinding: " + binding);
        }
        return binding;
    }

    @Override
    protected void closeIterator() {
        if (this.logging) {
            this.log.info("closeIterator");
        }
        super.closeIterator();
    }

    public void loggingOn() {
        this.logging(true);
    }

    public void loggingOff() {
        this.logging(false);
    }

    public void logging(boolean state) {
        this.logging = state;
    }
}

