/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.engine.join.JoinLib;

class HashProbeTable {
    long s_count = 0L;
    long s_bucketCount = 0L;
    long s_maxBucketSize = 0L;
    long s_noKeyBucketSize = 0L;
    long s_maxMatchGroup = 0L;
    long s_countScanMiss = 0L;
    private final List<Binding> noKeyBucket = new ArrayList<Binding>();
    private final Multimap<Object, Binding> buckets;
    private final JoinKey joinKey;

    HashProbeTable(JoinKey joinKey) {
        this.joinKey = joinKey;
        this.buckets = ArrayListMultimap.create();
    }

    public void put(Binding row) {
        ++this.s_count;
        Object longHash = JoinLib.hash(this.joinKey, row);
        if (longHash == JoinLib.noKeyHash) {
            this.noKeyBucket.add(row);
            return;
        }
        this.buckets.put(longHash, (Object)row);
    }

    public Iterator<Binding> getCandidates(Binding row) {
        Iterator iter = null;
        Object longHash = JoinLib.hash(this.joinKey, row);
        if (longHash == JoinLib.noKeyHash) {
            iter = this.buckets.values().iterator();
        } else {
            Collection x = this.buckets.get(longHash);
            if (x != null) {
                this.s_maxMatchGroup = Math.max(this.s_maxMatchGroup, (long)x.size());
                iter = x.iterator();
            } else {
                ++this.s_countScanMiss;
            }
        }
        if (this.noKeyBucket != null) {
            iter = Iter.concat(iter, this.noKeyBucket.iterator());
        }
        return iter;
    }

    public void stats() {
        long max2 = 0L;
        for (Object key : this.buckets.keys()) {
            long s = this.buckets.get(key).size();
            max2 = Math.max(max2, s);
        }
        this.s_maxBucketSize = max2;
        this.s_bucketCount = this.buckets.keys().size();
        this.s_noKeyBucketSize = this.noKeyBucket == null ? 0L : (long)this.noKeyBucket.size();
    }

    public Collection<Binding> getNoKey$() {
        if (this.noKeyBucket == null) {
            return null;
        }
        return this.noKeyBucket;
    }

    public Collection<Binding> getHashMatch$(Binding row) {
        Object longHash = JoinLib.hash(this.joinKey, row);
        if (longHash == JoinLib.noKeyHash) {
            return this.noKeyBucket;
        }
        Collection list = this.buckets.get(longHash);
        return list;
    }

    public Iterator<Binding> values() {
        return Iter.concat(this.buckets.values().iterator(), this.noKeyBucket.iterator());
    }

    public void clear() {
        this.buckets.clear();
    }
}

