/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;
import org.apache.jena.datatypes.xsd.impl.XSDBaseNumericType;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionBase1;
import org.apache.jena.sparql.function.FunctionFactory;

public class CastXSD
extends FunctionBase1
implements FunctionFactory {
    protected final XSDDatatype castType;

    public CastXSD(XSDDatatype dt) {
        this.castType = dt;
    }

    @Override
    public Function create(String uri) {
        return this;
    }

    @Override
    public NodeValue exec(NodeValue v) {
        return CastXSD.cast(v, this.castType);
    }

    private static boolean isTemporalDatatype(XSDDatatype datatype) {
        return datatype.equals(XSDDatatype.XSDdateTime) || datatype.equals(XSDDatatype.XSDtime) || datatype.equals(XSDDatatype.XSDdate) || datatype.equals(XSDDatatype.XSDgYear) || datatype.equals(XSDDatatype.XSDgYearMonth) || datatype.equals(XSDDatatype.XSDgMonth) || datatype.equals(XSDDatatype.XSDgMonthDay) || datatype.equals(XSDDatatype.XSDgDay);
    }

    private static boolean isDurationDatatype(XSDDatatype datatype) {
        return datatype.equals(XSDDatatype.XSDduration) || datatype.equals(XSDDatatype.XSDyearMonthDuration) || datatype.equals(XSDDatatype.XSDdayTimeDuration);
    }

    public static NodeValue cast(NodeValue nv, XSDDatatype castType) {
        Node n = nv.asNode();
        if (n.isBlank()) {
            throw CastXSD.exception("Can't cast blank nodes: " + nv);
        }
        if (n.isURI()) {
            if (castType.equals(XSDDatatype.XSDstring)) {
                return CastXSD.cast$(n.getURI(), castType);
            }
            throw CastXSD.exception("Can't cast URIs to " + castType.getURI());
        }
        if (!n.isLiteral()) {
            throw CastXSD.exception("Can't cast (not a literal, nor URI to string) " + nv + " : " + castType.getURI());
        }
        if (Objects.equals(nv.getNode().getLiteralDatatype(), castType)) {
            String lex = nv.getNode().getLiteralLexicalForm();
            if (castType.isValid(lex)) {
                return nv;
            }
            throw CastXSD.exception("Invalid lexical form for " + castType.getURI());
        }
        if (CastXSD.isTemporalDatatype(castType)) {
            return XSDFuncOp.dateTimeCast(nv, castType);
        }
        if (CastXSD.isDurationDatatype(castType) && nv.isDuration()) {
            Duration d = nv.getDuration();
            if (castType.equals(XSDDatatype.XSDyearMonthDuration)) {
                if (nv.isDayTimeDuration()) {
                    return NodeValue.makeNode("P0M", (RDFDatatype)castType);
                }
                Duration d2 = NodeValue.xmlDatatypeFactory.newDuration(d.getSign() >= 0, (BigInteger)d.getField(DatatypeConstants.YEARS), (BigInteger)d.getField(DatatypeConstants.MONTHS), null, null, null, null);
                return NodeValue.makeNode(d2.toString(), (RDFDatatype)castType);
            }
            if (castType.equals(XSDDatatype.XSDdayTimeDuration)) {
                if (nv.isYearMonthDuration()) {
                    return NodeValue.makeNode("PT0S", (RDFDatatype)castType);
                }
                Duration d2 = NodeValue.xmlDatatypeFactory.newDuration(d.getSign() >= 0, null, null, (BigInteger)d.getField(DatatypeConstants.DAYS), (BigInteger)d.getField(DatatypeConstants.HOURS), (BigInteger)d.getField(DatatypeConstants.MINUTES), (BigDecimal)d.getField(DatatypeConstants.SECONDS));
                return NodeValue.makeNode(d2.toString(), (RDFDatatype)castType);
            }
        }
        if (nv.isNumber()) {
            if (castType.equals(XSDDatatype.XSDdecimal)) {
                if (CastXSD.isDouble(nv) || CastXSD.isFloat(nv)) {
                    double d = nv.getDouble();
                    if (Double.isNaN(d)) {
                        throw CastXSD.exception("Can't cast NaN to xsd:decimal");
                    }
                    if (Double.isInfinite(d)) {
                        throw CastXSD.exception("Can't cast Inf or -Inf to xsd:decimal");
                    }
                    String lex = CastXSD.doubleToDecimalString(d);
                    return NodeValue.makeDecimal(lex);
                }
                return CastXSD.castByLex(nv, castType);
            }
            if (XSDFuncOp.isIntegerType(castType)) {
                if (CastXSD.isDouble(nv) || CastXSD.isFloat(nv)) {
                    String lex;
                    boolean isIntegerValue;
                    double d = nv.getDouble();
                    boolean bl = isIntegerValue = Math.rint(d) == d;
                    if (isIntegerValue && (lex = CastXSD.doubleIntegerToString(d)) != null) {
                        return CastXSD.castByLex(lex, castType);
                    }
                    throw CastXSD.exception(nv, castType);
                }
                if (CastXSD.isDecimal(nv)) {
                    BigDecimal bd = nv.getDecimal();
                    try {
                        BigInteger bi = bd.toBigIntegerExact();
                        return CastXSD.castByLex(bi.toString(), castType);
                    }
                    catch (ArithmeticException ex) {
                        throw new ExprEvalException("CastXSD: Not a valid cast: '" + nv + "'");
                    }
                }
                return CastXSD.castByLex(nv, castType);
            }
        }
        if (nv.isBoolean()) {
            boolean b = nv.getBoolean();
            if (XSDDatatype.XSDfloat.equals(castType) || XSDDatatype.XSDdouble.equals(castType)) {
                return CastXSD.cast$(b ? "1.0E0" : "0.0E0", castType);
            }
            if (XSDDatatype.XSDdecimal.equals(castType)) {
                return CastXSD.cast$(b ? "1.0" : "0.0", castType);
            }
            if (XSDFuncOp.isIntegerType(castType)) {
                return CastXSD.cast$(b ? "1" : "0", castType);
            }
            if (XSDDatatype.XSDstring.equals(castType)) {
                return CastXSD.cast$(nv.getNode().getLiteralLexicalForm(), castType);
            }
            throw CastXSD.exception("Can't cast xsd:boolean to " + castType);
        }
        return CastXSD.castByLex(nv, castType);
    }

    private static String xsdName(String datatype) {
        return datatype.replaceAll("http://www.w3.org/2001/XMLSchema#", "xsd:");
    }

    private static boolean isDouble(NodeValue nv) {
        return nv.isDouble() && nv.getDatatypeURI().equals(XSDDatatype.XSDdouble.getURI());
    }

    private static boolean isFloat(NodeValue nv) {
        return nv.isFloat() && nv.getDatatypeURI().equals(XSDDatatype.XSDfloat.getURI());
    }

    private static boolean isDecimal(NodeValue nv) {
        return nv.isDecimal() && nv.getDatatypeURI().equals(XSDDatatype.XSDdecimal.getURI());
    }

    private static boolean isNumeric(NodeValue nv) {
        return nv.isNumber();
    }

    private static ExprException exception(NodeValue nv, XSDDatatype dt) {
        return CastXSD.exception("Invalid cast: " + nv + " -> " + CastXSD.xsdName(dt.getURI()));
    }

    private static ExprException exception(String msg) {
        return new ExprEvalTypeException(msg);
    }

    private static NodeValue castByLex(NodeValue nv, XSDDatatype castType) {
        String lex = nv.getNode().getLiteralLexicalForm();
        return CastXSD.castByLex(lex, castType);
    }

    private static NodeValue castByLex(String lex, XSDDatatype castType) {
        if (!castType.isValid(lex)) {
            throw CastXSD.exception("Invalid lexical form: '" + lex + "' for " + castType.getURI());
        }
        if ((castType instanceof XSDBaseNumericType || castType.equals(XSDDatatype.XSDfloat) || castType.equals(XSDDatatype.XSDdouble) || castType.equals(XSDDatatype.XSDboolean) || castType instanceof XSDAbstractDateTimeType) && (lex.startsWith(" ") || lex.endsWith(" "))) {
            throw CastXSD.exception("Not a valid literal form (has whitespace): '" + lex + "'");
        }
        return NodeValue.makeNode(lex, (RDFDatatype)castType);
    }

    private static NodeValue cast$(String lex, XSDDatatype castType) {
        return NodeValue.makeNode(lex, (RDFDatatype)castType);
    }

    private static String doubleIntegerToString(double d) {
        long x = Math.round(d);
        if (x != Long.MAX_VALUE && x != Long.MIN_VALUE) {
            return Long.toString(x);
        }
        String lex = BigDecimal.valueOf(d).toPlainString();
        int i = lex.indexOf(46);
        if (i >= 0) {
            lex = lex.substring(0, i);
        }
        return lex;
    }

    private static String doubleToDecimalString(double d) {
        String lex = BigDecimal.valueOf(d).toPlainString();
        int i = lex.indexOf(46);
        if (i < 0) {
            return lex + ".0";
        }
        while (i < lex.length() - 2 && lex.endsWith("0")) {
            lex = lex.substring(0, lex.length() - 1);
        }
        return lex;
    }
}

